/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;

public class SliderTab
extends ExampleTab {
    private static final String PROP_CONTEXT_MENU = "contextMenu";
    private static final String PROP_SELECTION_LISTENER = "selectionListener";
    Slider slider;
    Spinner minimumSpinner;
    Spinner maximumSpinner;
    Spinner selectionSpinner;
    Spinner thumbSpinner;
    Spinner incrementSpinner;
    Spinner pageIncrementSpinner;

    public SliderTab(CTabFolder folder) {
        super(folder, "Slider");
        this.setDefaultStyle(256);
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton(parent, "HORIZONTAL", 256, 16, true);
        this.createStyleButton(parent, "VERTICAL", 512, 16, false);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.minimumSpinner = this.createSpinnerControl(parent, "Minimum", 0, 100000, 0);
        this.minimumSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int minimum = SliderTab.this.minimumSpinner.getSelection();
                SliderTab.this.slider.setMinimum(minimum);
            }
        });
        this.maximumSpinner = this.createSpinnerControl(parent, "Maximum", 0, 100000, 100);
        this.maximumSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int maximum = SliderTab.this.maximumSpinner.getSelection();
                SliderTab.this.slider.setMaximum(maximum);
            }
        });
        this.selectionSpinner = this.createSpinnerControl(parent, "Selection", 0, 100000, 0);
        this.selectionSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int selection = SliderTab.this.selectionSpinner.getSelection();
                SliderTab.this.slider.setSelection(selection);
            }
        });
        this.thumbSpinner = this.createSpinnerControl(parent, "Thumb", 1, 100000, 10);
        this.thumbSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int thumb = SliderTab.this.thumbSpinner.getSelection();
                SliderTab.this.slider.setThumb(thumb);
            }
        });
        this.incrementSpinner = this.createSpinnerControl(parent, "Increment", 0, 100000, 1);
        this.incrementSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int increment = SliderTab.this.incrementSpinner.getSelection();
                SliderTab.this.slider.setIncrement(increment);
            }
        });
        this.pageIncrementSpinner = this.createSpinnerControl(parent, "Page Increment", 0, 100000, 10);
        this.pageIncrementSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int pageIncrement = SliderTab.this.pageIncrementSpinner.getSelection();
                SliderTab.this.slider.setPageIncrement(pageIncrement);
            }
        });
        this.createPropertyCheckbox("Add Context Menu", PROP_CONTEXT_MENU);
        this.createPropertyCheckbox("Add Selection Listener", PROP_SELECTION_LISTENER);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        int style = this.getStyle();
        this.slider = new Slider(parent, style);
        if (this.hasCreateProperty(PROP_CONTEXT_MENU)) {
            Menu sliderMenu = new Menu((Control)this.slider);
            MenuItem sliderMenuItem = new MenuItem(sliderMenu, 8);
            sliderMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "You requested a context menu for the Slider";
                    MessageDialog.openInformation((Shell)SliderTab.this.slider.getShell(), (String)"Information", (String)message);
                }
            });
            sliderMenuItem.setText("Slider context menu item");
            this.slider.setMenu(sliderMenu);
        }
        if (this.hasCreateProperty(PROP_SELECTION_LISTENER)) {
            this.slider.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "Slider WidgetSelected! Current selection: " + SliderTab.this.slider.getSelection();
                    SliderTab.this.log(message);
                    SliderTab.this.selectionSpinner.setSelection(SliderTab.this.slider.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    String message = "Slider WidgetDefaultSelected! Current selection: " + SliderTab.this.slider.getSelection();
                    SliderTab.this.log(message);
                    SliderTab.this.selectionSpinner.setSelection(SliderTab.this.slider.getSelection());
                }
            });
        }
        if (this.minimumSpinner != null) {
            this.slider.setMinimum(this.minimumSpinner.getSelection());
        }
        if (this.maximumSpinner != null) {
            this.slider.setMaximum(this.maximumSpinner.getSelection());
        }
        if (this.selectionSpinner != null) {
            this.slider.setSelection(this.selectionSpinner.getSelection());
        }
        if (this.thumbSpinner != null) {
            this.slider.setThumb(this.thumbSpinner.getSelection());
        }
        if (this.incrementSpinner != null) {
            this.slider.setIncrement(this.incrementSpinner.getSelection());
        }
        if (this.pageIncrementSpinner != null) {
            this.slider.setPageIncrement(this.pageIncrementSpinner.getSelection());
        }
        this.registerControl((Control)this.slider);
    }

    protected Button createStyleButton(Composite parent, String name, int style, int buttonStyle, boolean checked) {
        Button button = new Button(parent, buttonStyle);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SliderTab.this.createNew();
            }
        });
        button.setData("style", (Object)new Integer(style));
        button.setSelection(checked);
        return button;
    }

    private Spinner createSpinnerControl(Composite parent, String labelText, int minimum, int maximum, int selection) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(composite, 0);
        label.setText(labelText);
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setSelection(selection);
        spinner.setMinimum(minimum);
        spinner.setMaximum(maximum);
        return spinner;
    }
}

