/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.events;

import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public final class TreeEvent
extends SelectionEvent {
    private static final long serialVersionUID = 1L;
    public static final int TREE_EXPANDED = 17;
    public static final int TREE_COLLAPSED = 18;
    private static final Class LISTENER = TreeListener.class;

    public TreeEvent(Event event) {
        super(event);
    }

    public TreeEvent(Widget widget, Widget item, int id) {
        super(widget, item, id);
    }

    protected void dispatchToObserver(Object listener) {
        switch (this.getID()) {
            case 17: {
                ((TreeListener)listener).treeExpanded(this);
                break;
            }
            case 18: {
                ((TreeListener)listener).treeCollapsed(this);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event handler type.");
            }
        }
    }

    protected Class getListenerType() {
        return LISTENER;
    }

    protected boolean allowProcessing() {
        return EventUtil.isAccessible(this.widget);
    }

    public static void addListener(Adaptable adaptable, TreeListener listener) {
        TreeEvent.addListener(adaptable, LISTENER, listener);
    }

    public static void removeListener(Adaptable adaptable, TreeListener listener) {
        TreeEvent.removeListener(adaptable, LISTENER, listener);
    }

    public static boolean hasListener(Adaptable adaptable) {
        return TreeEvent.hasListener(adaptable, LISTENER);
    }

    public static Object[] getListeners(Adaptable adaptable) {
        return TreeEvent.getListener(adaptable, LISTENER);
    }
}

