/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ZOrderTab
extends ExampleTab {
    private Label label;

    public ZOrderTab(CTabFolder topFolder) {
        super(topFolder, "Z-Order");
    }

    protected void createStyleControls(Composite parent) {
    }

    protected void createExampleControls(Composite top) {
        top.setLayout((Layout)new FormLayout());
        final Composite comp = new Composite(top, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData fdComp = new FormData();
        fdComp.top = new FormAttachment(0, 0);
        fdComp.left = new FormAttachment(0, 0);
        fdComp.right = new FormAttachment(100, 0);
        fdComp.bottom = new FormAttachment(70, 0);
        comp.setLayoutData((Object)fdComp);
        final Label labelA = this.createLabel(comp, 15, 45);
        labelA.setText("A");
        labelA.setBackground(BG_COLOR_BLUE);
        final Label labelB = this.createLabel(comp, 35, 65);
        labelB.setText("B");
        labelB.setBackground(BG_COLOR_GREEN);
        final Label labelC = this.createLabel(comp, 55, 85);
        labelC.setText("C");
        labelC.setBackground(BG_COLOR_BROWN);
        this.label = new Label(comp, 0x1000000);
        FormData fdData = fdComp;
        fdData.top = new FormAttachment((Control)labelC, labelC.getSize().y + 10);
        fdData.left = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)fdData);
        this.label.setText("trallala");
        Button aboveA = this.createButton(top, 80, 10, 36);
        aboveA.setText("B above A");
        aboveA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                labelB.moveAbove((Control)labelA);
                ZOrderTab.this.printChildren(comp);
            }
        });
        Button belowA = this.createButton(top, (Control)aboveA, 10, 36);
        belowA.setText("B below A");
        belowA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                labelB.moveBelow((Control)labelA);
                ZOrderTab.this.printChildren(comp);
            }
        });
        Button aboveAll = this.createButton(top, 80, 37, 63);
        aboveAll.setText("B above all");
        aboveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                labelB.moveAbove(null);
                ZOrderTab.this.printChildren(comp);
            }
        });
        Button belowAll = this.createButton(top, (Control)aboveAll, 37, 63);
        belowAll.setText("B below all");
        belowAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                labelB.moveBelow(null);
                ZOrderTab.this.printChildren(comp);
            }
        });
        Button aboveC = this.createButton(top, 80, 64, 90);
        aboveC.setText("B above C");
        aboveC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                labelB.moveAbove((Control)labelC);
                ZOrderTab.this.printChildren(comp);
            }
        });
        Button belowC = this.createButton(top, (Control)aboveC, 64, 90);
        belowC.setText("B below C");
        belowC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                labelB.moveBelow((Control)labelC);
                ZOrderTab.this.printChildren(comp);
            }
        });
        top.setTabList(new Control[]{aboveA, aboveAll, aboveC, belowA, belowAll, belowC});
    }

    private Button createButton(Composite composite, int top, int left, int right) {
        Button result = new Button(composite, 8);
        FormData fdButton = new FormData();
        fdButton.top = new FormAttachment(top, 0);
        fdButton.left = new FormAttachment(left, 0);
        fdButton.right = new FormAttachment(right, 0);
        result.setLayoutData((Object)fdButton);
        return result;
    }

    private Button createButton(Composite composite, Control top, int left, int right) {
        Button result = new Button(composite, 8);
        FormData fdButton = new FormData();
        fdButton.top = new FormAttachment(top, 1);
        fdButton.left = new FormAttachment(left, 0);
        fdButton.right = new FormAttachment(right, 0);
        result.setLayoutData((Object)fdButton);
        return result;
    }

    private Label createLabel(Composite top, int topAndLeft, int rightAndBottom) {
        Label result = new Label(top, 0x1000800);
        FormData fdLabel = new FormData();
        fdLabel.top = new FormAttachment(topAndLeft, 0);
        fdLabel.left = new FormAttachment(topAndLeft, 0);
        fdLabel.right = new FormAttachment(rightAndBottom, 0);
        fdLabel.bottom = new FormAttachment(rightAndBottom, 0);
        result.setLayoutData((Object)fdLabel);
        return result;
    }

    private void printChildren(Composite comp) {
        Control[] children = comp.getChildren();
        StringBuffer sb = new StringBuffer("Z-Order: ");
        int i = 0;
        while (i < children.length) {
            sb.append(String.valueOf(((Label)children[i]).getText()) + " ");
            ++i;
        }
        this.label.setText(sb.toString());
    }
}

