/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.views.log.Activator;
import org.eclipse.ui.internal.views.log.Messages;

public class DownloadServiceHandler
implements ServiceHandler {
    private File fInputFile;

    public DownloadServiceHandler(File pInputFile) {
        this.fInputFile = pInputFile;
    }

    public DownloadServiceHandler() {
        this(Platform.getLogFileLocation().toFile());
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/octet-stream");
        response.setContentLength((int)this.fInputFile.length());
        String fileName = this.fInputFile.getName();
        if (fileName.charAt(0) == '.') {
            fileName = "pde" + fileName;
        }
        String contentDisposition = "attachment; filename=\"" + fileName + '\"';
        response.setHeader("Content-Disposition", contentDisposition);
        try (InputStream inputStream = null;){
            try {
                inputStream = new FileInputStream(this.fInputFile);
                int b = inputStream.read();
                while (b != -1) {
                    response.getOutputStream().write(b);
                    b = inputStream.read();
                }
            }
            catch (IOException e1) {
                MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.get().LogView_exportLog, (String)e1.toString());
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }
}

