/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.dropdown.demo.examples;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.rap.rwt.SingletonUtil;

public class CountryInfo {
    private static final String CHARSET = "UTF-8";
    private Country[] countries;

    public static CountryInfo getInstance() {
        return (CountryInfo)SingletonUtil.getSessionInstance(CountryInfo.class);
    }

    public Country[] getCountries() {
        return this.countries;
    }

    public Country findCountry(String name) {
        Country[] countryArray = this.countries;
        int n = this.countries.length;
        int n2 = 0;
        while (n2 < n) {
            Country country = countryArray[n2];
            if (country.name.equals(name)) {
                return country;
            }
            ++n2;
        }
        return null;
    }

    private CountryInfo() {
        try {
            this.countries = CountryInfo.readCountries();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not parse countries", ex);
        }
    }

    private static Country[] readCountries() throws IOException {
        File file = new File(CountryInfo.getGeoDataDirectory(), "countries.txt");
        FileInputStream stream = new FileInputStream(file);
        ArrayList<Country> countries = new ArrayList<Country>(252);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, CHARSET));){
            String line = reader.readLine();
            while (line != null) {
                if (line.charAt(0) != '#') {
                    countries.add(new Country(line));
                }
                line = reader.readLine();
            }
        }
        return countries.toArray(new Country[0]);
    }

    private static City[] readCities(Country country) throws IOException {
        File file = new File(CountryInfo.getGeoDataDirectory(), "cities/" + country.iso + ".txt");
        FileInputStream stream = new FileInputStream(file);
        ArrayList<City> cities = new ArrayList<City>(250);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, CHARSET));){
            String line = reader.readLine();
            while (line != null) {
                if (line.charAt(0) != '#') {
                    cities.add(new City(line));
                }
                line = reader.readLine();
            }
        }
        return cities.toArray(new City[0]);
    }

    private static File getGeoDataDirectory() {
        File dataDirectory = new File("/data/rapdemo");
        return new File(dataDirectory, "geodata");
    }

    static class City {
        public final String name;
        public final double latitude;
        public final double longitude;

        public City(String line) {
            String[] data = line.split("\t");
            this.name = data[0];
            this.latitude = Double.parseDouble(data[1]);
            this.longitude = Double.parseDouble(data[2]);
        }

        public String toString() {
            return this.name;
        }
    }

    static class Country {
        public final String iso;
        public final String name;
        private City[] cities = null;

        public Country(String line) {
            String[] data = line.split("\t");
            this.iso = data[0];
            this.name = data[1];
        }

        public String toString() {
            return this.name;
        }

        public City[] getCities() {
            if (this.cities == null) {
                try {
                    this.cities = CountryInfo.readCities(this);
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Could not parse cities for " + this.name, ex);
                }
            }
            return this.cities;
        }

        public City findCity(String name) {
            City[] cityArray = this.cities;
            int n = this.cities.length;
            int n2 = 0;
            while (n2 < n) {
                City city = cityArray[n2];
                if (city.name.equals(name)) {
                    return city;
                }
                ++n2;
            }
            return null;
        }
    }
}

