/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.chart.demo;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.addons.chart.basic.MapChart;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.widgets.Composite;

public class WorldMapChart
extends MapChart {
    public WorldMapChart(Composite parent, int style) {
        super(parent, style, WorldMapChart.registerGeoData("resources/world-110m.json"));
    }

    private static String registerGeoData(String path) {
        ResourceManager resourceManager = RWT.getResourceManager();
        if (!resourceManager.isRegistered(path)) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream inputStream = WorldMapChart.getResourceLoader().getResourceAsStream(path);){
                    resourceManager.register(path, inputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to register resource " + path, exception);
            }
        }
        return resourceManager.getLocation(path);
    }

    private static ResourceLoader getResourceLoader() {
        final ClassLoader classLoader = WorldMapChart.class.getClassLoader();
        return new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                return classLoader.getResourceAsStream(resourceName);
            }
        };
    }
}

