/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.griditemkit;

import java.io.IOException;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.nebula.widgets.grid.internal.IGridItemAdapter;
import org.eclipse.nebula.widgets.grid.internal.griditemkit.GridItemOperationHandler;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapterImpl;
import org.eclipse.swt.widgets.Widget;

public class GridItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.GridItem";
    private static final String PROP_INDEX = "index";
    private static final String PROP_ITEM_COUNT = "itemCount";
    private static final String PROP_HEIGHT = "height";
    private static final String PROP_TEXTS = "texts";
    private static final String PROP_IMAGES = "images";
    private static final String PROP_CELL_BACKGROUNDS = "cellBackgrounds";
    private static final String PROP_CELL_FOREGROUNDS = "cellForegrounds";
    private static final String PROP_CELL_FONTS = "cellFonts";
    private static final String PROP_EXPANDED = "expanded";
    private static final String PROP_CELL_CHECKED = "cellChecked";
    private static final String PROP_CELL_GRAYED = "cellGrayed";
    private static final String PROP_CELL_CHECKABLE = "cellCheckable";
    private static final String PROP_CACHED = "cached";
    private static final int ZERO = 0;

    public void renderInitialization(Widget widget) throws IOException {
        GridItem item = (GridItem)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject((Widget)item, (String)TYPE);
        remoteObject.setHandler((OperationHandler)new GridItemOperationHandler(item));
        remoteObject.set("parent", WidgetUtil.getId((Widget)GridItemLCA.getParent(item)));
    }

    public void preserveValues(Widget widget) {
        GridItem item = (GridItem)widget;
        WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_INDEX, (int)GridItemLCA.getItemIndex(item));
        WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_CACHED, (boolean)GridItemLCA.isCached(item));
        if (GridItemLCA.isCached(item)) {
            WidgetLCAUtil.preserveCustomVariant((Widget)item);
            WidgetLCAUtil.preserveData((Widget)item);
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_ITEM_COUNT, (int)item.getItemCount());
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_HEIGHT, (int)item.getHeight());
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_TEXTS, (Object)GridItemLCA.getTexts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_IMAGES, (Object)GridItemLCA.getImages(item));
            WidgetLCAUtil.preserveBackground((Widget)item, (Color)GridItemLCA.getUserBackground(item));
            WidgetLCAUtil.preserveForeground((Widget)item, (Color)GridItemLCA.getUserForeground(item));
            WidgetLCAUtil.preserveFont((Widget)item, (Font)GridItemLCA.getUserFont(item));
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_CELL_BACKGROUNDS, (Object)GridItemLCA.getCellBackgrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_CELL_FOREGROUNDS, (Object)GridItemLCA.getCellForegrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_CELL_FONTS, (Object)GridItemLCA.getCellFonts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_EXPANDED, (boolean)item.isExpanded());
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_CELL_CHECKED, (Object)GridItemLCA.getCellChecked(item));
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_CELL_GRAYED, (Object)GridItemLCA.getCellGrayed(item));
            WidgetLCAUtil.preserveProperty((Widget)item, (String)PROP_CELL_CHECKABLE, (Object)GridItemLCA.getCellCheckable(item));
        }
    }

    public void renderChanges(Widget widget) throws IOException {
        final GridItem item = (GridItem)widget;
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_INDEX, (int)GridItemLCA.getItemIndex(item), (int)-1);
        if (GridItemLCA.wasCleared(item)) {
            GridItemLCA.renderClear(item);
        } else if (GridItemLCA.isCached(item)) {
            GridItemLCA.preservingInitialized(item, new Runnable(){

                public void run() {
                    if (!GridItemLCA.wasCached(item)) {
                        GridItemLCA.setInitialized(item, false);
                    }
                    GridItemLCA.renderProperties(item);
                }
            });
        }
    }

    private static void renderClear(GridItem item) {
        RemoteObjectFactory.getRemoteObject((Widget)item).call("clear", null);
    }

    private static void renderProperties(GridItem item) {
        WidgetLCAUtil.renderCustomVariant((Widget)item);
        WidgetLCAUtil.renderData((Widget)item);
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_ITEM_COUNT, (int)item.getItemCount(), (int)0);
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_HEIGHT, (int)item.getHeight(), (int)item.getParent().getItemHeight());
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_TEXTS, (String[])GridItemLCA.getTexts(item), (String[])GridItemLCA.getDefaultTexts(item));
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_IMAGES, (Image[])GridItemLCA.getImages(item), (Image[])new Image[GridItemLCA.getColumnCount(item)]);
        WidgetLCAUtil.renderBackground((Widget)item, (Color)GridItemLCA.getUserBackground(item));
        WidgetLCAUtil.renderForeground((Widget)item, (Color)GridItemLCA.getUserForeground(item));
        WidgetLCAUtil.renderFont((Widget)item, (Font)GridItemLCA.getUserFont(item));
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_CELL_BACKGROUNDS, (Color[])GridItemLCA.getCellBackgrounds(item), (Color[])new Color[GridItemLCA.getColumnCount(item)]);
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_CELL_FOREGROUNDS, (Color[])GridItemLCA.getCellForegrounds(item), (Color[])new Color[GridItemLCA.getColumnCount(item)]);
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_CELL_FONTS, (Font[])GridItemLCA.getCellFonts(item), (Font[])new Font[GridItemLCA.getColumnCount(item)]);
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_EXPANDED, (boolean)item.isExpanded(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_CELL_CHECKED, (boolean[])GridItemLCA.getCellChecked(item), (boolean[])new boolean[GridItemLCA.getColumnCount(item)]);
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_CELL_GRAYED, (boolean[])GridItemLCA.getCellGrayed(item), (boolean[])new boolean[GridItemLCA.getColumnCount(item)]);
        WidgetLCAUtil.renderProperty((Widget)item, (String)PROP_CELL_CHECKABLE, (boolean[])GridItemLCA.getCellCheckable(item), (boolean[])GridItemLCA.getDefaultCellCheckable(item));
    }

    public void renderDispose(Widget widget) throws IOException {
        GridItem item = (GridItem)widget;
        RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject((Widget)widget);
        if (!GridItemLCA.isParentDisposed(item)) {
            remoteObject.destroy();
        } else {
            ((RemoteObjectImpl)remoteObject).markDestroyed();
        }
    }

    private static boolean wasCleared(GridItem item) {
        return !GridItemLCA.isCached(item) && GridItemLCA.wasCached(item);
    }

    private static boolean isCached(GridItem item) {
        return GridItemLCA.getGridItemAdapter(item).isCached();
    }

    private static boolean wasCached(GridItem item) {
        WidgetAdapter adapter = WidgetUtil.getAdapter((Widget)item);
        if (adapter.isInitialized()) {
            return Boolean.TRUE.equals(adapter.getPreserved(PROP_CACHED));
        }
        return false;
    }

    private static Widget getParent(GridItem item) {
        Object result = item.getParent();
        GridItem parentItem = item.getParentItem();
        if (parentItem != null) {
            result = item.getParentItem();
        }
        return result;
    }

    private static int getItemIndex(GridItem item) {
        return GridItemLCA.getGridAdapter(item.getParent()).getItemIndex(item);
    }

    private static boolean isParentDisposed(GridItem item) {
        return GridItemLCA.getGridItemAdapter(item).isParentDisposed();
    }

    private static String[] getTexts(GridItem item) {
        String[] result = new String[GridItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = item.getText(i);
            ++i;
        }
        return result;
    }

    private static String[] getDefaultTexts(GridItem item) {
        String[] result = new String[GridItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = "";
            ++i;
        }
        return result;
    }

    private static Image[] getImages(GridItem item) {
        Image[] result = new Image[GridItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = item.getImage(i);
            ++i;
        }
        return result;
    }

    private static Color getUserBackground(GridItem item) {
        return item.getAdapter(IWidgetColorAdapter.class).getUserBackground();
    }

    private static Color getUserForeground(GridItem item) {
        return item.getAdapter(IWidgetColorAdapter.class).getUserForeground();
    }

    private static Font getUserFont(GridItem item) {
        return item.getAdapter(IWidgetFontAdapter.class).getUserFont();
    }

    private static Color[] getCellBackgrounds(GridItem item) {
        return GridItemLCA.getGridItemAdapter(item).getCellBackgrounds();
    }

    private static Color[] getCellForegrounds(GridItem item) {
        return GridItemLCA.getGridItemAdapter(item).getCellForegrounds();
    }

    private static Font[] getCellFonts(GridItem item) {
        return GridItemLCA.getGridItemAdapter(item).getCellFonts();
    }

    private static boolean[] getCellChecked(GridItem item) {
        boolean[] result = new boolean[GridItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = item.getChecked(i);
            ++i;
        }
        return result;
    }

    private static boolean[] getCellGrayed(GridItem item) {
        boolean[] result = new boolean[GridItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = item.getGrayed(i);
            ++i;
        }
        return result;
    }

    private static boolean[] getCellCheckable(GridItem item) {
        boolean[] result = new boolean[GridItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = item.getCheckable(i);
            ++i;
        }
        return result;
    }

    private static boolean[] getDefaultCellCheckable(GridItem item) {
        boolean[] result = new boolean[GridItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = true;
            ++i;
        }
        return result;
    }

    private static int getColumnCount(GridItem item) {
        return Math.max(1, item.getParent().getColumnCount());
    }

    private static IGridAdapter getGridAdapter(Grid grid) {
        return grid.getAdapter(IGridAdapter.class);
    }

    private static IGridItemAdapter getGridItemAdapter(GridItem item) {
        return item.getAdapter(IGridItemAdapter.class);
    }

    private static void preservingInitialized(GridItem item, Runnable runnable) {
        boolean initialized = WidgetUtil.getAdapter((Widget)item).isInitialized();
        runnable.run();
        GridItemLCA.setInitialized(item, initialized);
    }

    private static void setInitialized(GridItem item, boolean initialized) {
        WidgetAdapterImpl adapter = (WidgetAdapterImpl)WidgetUtil.getAdapter((Widget)item);
        adapter.setInitialized(initialized);
    }
}

