/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.rap.swt.graphics.ColorUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ColorConstants {
    public static Color buttonLightest() {
        return SystemColorFactory.getColor(20);
    }

    public static Color button() {
        return SystemColorFactory.getColor(22);
    }

    public static Color buttonDarker() {
        return SystemColorFactory.getColor(18);
    }

    public static Color buttonDarkest() {
        return SystemColorFactory.getColor(17);
    }

    public static Color listBackground() {
        return SystemColorFactory.getColor(25);
    }

    public static Color listForeground() {
        return SystemColorFactory.getColor(24);
    }

    public static Color menuBackground() {
        return SystemColorFactory.getColor(22);
    }

    public static Color menuForeground() {
        return SystemColorFactory.getColor(21);
    }

    public static Color menuBackgroundSelected() {
        return SystemColorFactory.getColor(26);
    }

    public static Color menuForegroundSelected() {
        return SystemColorFactory.getColor(27);
    }

    public static Color titleBackground() {
        return SystemColorFactory.getColor(31);
    }

    public static Color titleGradient() {
        return SystemColorFactory.getColor(32);
    }

    public static Color titleForeground() {
        return SystemColorFactory.getColor(30);
    }

    public static Color titleInactiveForeground() {
        return SystemColorFactory.getColor(33);
    }

    public static Color titleInactiveBackground() {
        return SystemColorFactory.getColor(34);
    }

    public static Color titleInactiveGradient() {
        return SystemColorFactory.getColor(35);
    }

    public static Color tooltipForeground() {
        return SystemColorFactory.getColor(28);
    }

    public static Color tooltipBackground() {
        return SystemColorFactory.getColor(29);
    }

    public static Color white() {
        return ColorUtil.getColor((int)255);
    }

    public static Color lightGray() {
        return ColorUtil.getColor((int)192);
    }

    public static Color gray() {
        return ColorUtil.getColor((int)128);
    }

    public static Color darkGray() {
        return ColorUtil.getColor((int)64);
    }

    public static Color black() {
        return ColorUtil.getColor((int)0);
    }

    public static Color red() {
        return ColorUtil.getColor((int)255, (int)0, (int)0);
    }

    public static Color orange() {
        return ColorUtil.getColor((int)255, (int)196, (int)0);
    }

    public static Color yellow() {
        return ColorUtil.getColor((int)255, (int)255, (int)0);
    }

    public static Color green() {
        return ColorUtil.getColor((int)0, (int)255, (int)0);
    }

    public static Color lightGreen() {
        return ColorUtil.getColor((int)96, (int)255, (int)96);
    }

    public static Color darkGreen() {
        return ColorUtil.getColor((int)0, (int)127, (int)0);
    }

    public static Color cyan() {
        return ColorUtil.getColor((int)0, (int)255, (int)255);
    }

    public static Color lightBlue() {
        return ColorUtil.getColor((int)127, (int)127, (int)255);
    }

    public static Color blue() {
        return ColorUtil.getColor((int)0, (int)0, (int)255);
    }

    public static Color darkBlue() {
        return ColorUtil.getColor((int)0, (int)0, (int)127);
    }

    static class SystemColorFactory {
        SystemColorFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Color getColor(final int which) {
            Display display = Display.getCurrent();
            if (display != null) {
                return display.getSystemColor(which);
            }
            display = Display.getDefault();
            final Color[] result = new Color[1];
            display.syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Color[] colorArray = result;
                    synchronized (result) {
                        result[0] = Display.getCurrent().getSystemColor(which);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            Color[] colorArray = result;
            synchronized (result) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return result[0];
            }
        }
    }
}

