/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.properties;

import java.util.EventObject;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.ForwardUndoCompoundCommand;
import org.eclipse.gef.ui.properties.SetPropertyValueCommand;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetEntry;

public class UndoablePropertySheetEntry
extends PropertySheetEntry {
    private CommandStackListener commandStackListener;
    private CommandStack commandStack;

    private UndoablePropertySheetEntry() {
    }

    public UndoablePropertySheetEntry(CommandStack commandStack) {
        this.commandStack = commandStack;
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject e) {
                UndoablePropertySheetEntry.this.refreshFromRoot();
            }
        };
        this.commandStack.addCommandStackListener(this.commandStackListener);
    }

    protected PropertySheetEntry createChildEntry() {
        return new UndoablePropertySheetEntry();
    }

    public void dispose() {
        if (this.commandStack != null) {
            this.commandStack.removeCommandStackListener(this.commandStackListener);
        }
        super.dispose();
    }

    protected CommandStack getCommandStack() {
        if (this.getParent() != null) {
            return ((UndoablePropertySheetEntry)this.getParent()).getCommandStack();
        }
        return this.commandStack;
    }

    public void resetPropertyValue() {
        CompoundCommand cc = new CompoundCommand();
        if (this.getParent() == null) {
            return;
        }
        boolean change = false;
        Object[] objects = this.getParent().getValues();
        int i = 0;
        while (i < objects.length) {
            IPropertySource source = this.getPropertySource(objects[i]);
            if (source.isPropertySet(this.getDescriptor().getId())) {
                SetPropertyValueCommand restoreCmd = new SetPropertyValueCommand(this.getDescriptor().getDisplayName(), source, this.getDescriptor().getId(), SetPropertyValueCommand.DEFAULT_VALUE);
                cc.add(restoreCmd);
                change = true;
            }
            ++i;
        }
        if (change) {
            this.getCommandStack().execute(cc);
            this.refreshFromRoot();
        }
    }

    protected void valueChanged(PropertySheetEntry child) {
        this.valueChanged((UndoablePropertySheetEntry)child, new ForwardUndoCompoundCommand());
    }

    private void valueChanged(UndoablePropertySheetEntry child, CompoundCommand command) {
        CompoundCommand cc = new CompoundCommand();
        command.add(cc);
        int i = 0;
        while (i < this.getValues().length) {
            SetPropertyValueCommand setCommand = new SetPropertyValueCommand(child.getDisplayName(), this.getPropertySource(this.getValues()[i]), child.getDescriptor().getId(), child.getValues()[i]);
            cc.add(setCommand);
            ++i;
        }
        if (this.getParent() != null) {
            ((UndoablePropertySheetEntry)this.getParent()).valueChanged(this, command);
        } else {
            this.commandStack.execute(command);
        }
    }
}

