/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageSerializer;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.InternalImage;
import org.eclipse.swt.internal.graphics.InternalImageFactory;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public final class Image
extends Resource {
    public final InternalImage internalImage;

    private Image(Device device, InternalImage internalImage) {
        super(device);
        this.internalImage = internalImage;
    }

    public Image(Device device, InputStream stream) {
        super(Image.checkDevice(device));
        if (stream == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(stream);
    }

    public Image(Device device, String fileName) {
        super(Image.checkDevice(device));
        if (fileName == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(fileName);
    }

    public Image(Device device, Image srcImage, int flag) {
        super(Image.checkDevice(device));
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: {
                this.internalImage = srcImage.internalImage;
                break;
            }
            default: {
                this.internalImage = null;
                SWT.error(5);
            }
        }
    }

    public Image(Device device, ImageData imageData) {
        super(Image.checkDevice(device));
        if (imageData == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(imageData);
    }

    public Image(Device device, int width, int height) {
        super(Image.checkDevice(device));
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        Color white = device.getSystemColor(1);
        PaletteData palette = new PaletteData(new RGB[]{white.getRGB()});
        ImageData imageData = new ImageData(width, height, 8, palette);
        this.internalImage = Image.findInternalImage(imageData);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.internalImage.getBounds();
    }

    public ImageData getImageData() {
        ImageData result;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.device != null) {
            ApplicationContextImpl applicationContext = this.getApplicationContext();
            result = applicationContext.getImageDataFactory().findImageData(this.internalImage);
        } else {
            result = this.internalImage.getImageData();
        }
        return result;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.device == null) {
            throw new NotSerializableException(this.getClass().getName());
        }
        new ImageSerializer(this).writeObject(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        new ImageSerializer(this).readObject(stream);
    }

    private ApplicationContextImpl getApplicationContext() {
        Display display = (Display)this.device;
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return (ApplicationContextImpl)adapter.getUISession().getApplicationContext();
    }

    private static InternalImage findInternalImage(ImageData imageData) {
        return Image.getInternalImageFactory().findInternalImage(imageData);
    }

    private static InternalImage findInternalImage(InputStream stream) {
        return Image.getInternalImageFactory().findInternalImage(stream);
    }

    private static InternalImage findInternalImage(String fileName) {
        return Image.getInternalImageFactory().findInternalImage(fileName);
    }

    private static InternalImageFactory getInternalImageFactory() {
        return ContextProvider.getApplicationContext().getInternalImageFactory();
    }
}

