/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.compress.CompressLZF;
import org.h2.store.fs.FileObject;
import org.h2.util.MathUtils;

public class FileObjectMemory
implements FileObject {
    private static final int CACHE_SIZE = 8;
    private static final int BLOCK_SIZE_SHIFT = 16;
    private static final int BLOCK_SIZE = 65536;
    private static final int BLOCK_SIZE_MASK = 65535;
    private static final CompressLZF LZF = new CompressLZF();
    private static final byte[] BUFFER = new byte[131072];
    private static byte[] cachedCompressedEmptyBlock;
    private static final Cache<CompressItem, CompressItem> COMPRESS_LATER;
    private String name;
    private final boolean compress;
    private long length;
    private long pos;
    private byte[][] data;
    private long lastModified;

    FileObjectMemory(String string, boolean bl) {
        this.name = string;
        this.compress = bl;
        this.data = new byte[0][];
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressLater(byte[][] byArray, int n) {
        CompressItem compressItem = new CompressItem();
        compressItem.data = byArray;
        compressItem.page = n;
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            COMPRESS_LATER.put(compressItem, compressItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(byte[][] byArray, int n) {
        byte[] byArray2 = byArray[n];
        if (byArray2.length == 65536) {
            return;
        }
        byte[] byArray3 = new byte[65536];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            LZF.expand(byArray2, 0, byArray2.length, byArray3, 0, 65536);
        }
        byArray[n] = byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compress(byte[][] byArray, int n) {
        byte[] byArray2 = byArray[n];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            int n2 = LZF.compress(byArray2, 65536, BUFFER, 0);
            if (n2 <= 65536) {
                byArray2 = new byte[n2];
                System.arraycopy(BUFFER, 0, byArray2, 0, n2);
                byArray[n] = byArray2;
            }
        }
    }

    static byte[] getCompressedEmptyBlock() {
        if (cachedCompressedEmptyBlock == null) {
            byte[] byArray = new byte[65536];
            int n = LZF.compress(byArray, 65536, BUFFER, 0);
            cachedCompressedEmptyBlock = new byte[n];
            System.arraycopy(BUFFER, 0, cachedCompressedEmptyBlock, 0, n);
        }
        return cachedCompressedEmptyBlock;
    }

    private void touch() {
        this.lastModified = System.currentTimeMillis();
    }

    public long length() {
        return this.length;
    }

    public void setFileLength(long l) {
        this.touch();
        if (l < this.length) {
            this.pos = Math.min(this.pos, l);
            this.changeLength(l);
            long l2 = MathUtils.roundUpLong(l, 65536L);
            if (l2 != l) {
                int n = (int)(l >>> 16);
                FileObjectMemory.expand(this.data, n);
                byte[] byArray = this.data[n];
                for (int i = (int)(l & 0xFFFFL); i < 65536; ++i) {
                    byArray[i] = 0;
                }
                if (this.compress) {
                    FileObjectMemory.compressLater(this.data, n);
                }
            }
        } else {
            this.changeLength(l);
        }
    }

    public void seek(long l) {
        this.pos = (int)l;
    }

    private void changeLength(long l) {
        this.length = l;
        int n = (int)((l = MathUtils.roundUpLong(l, 65536L)) >>> 16);
        if (n != this.data.length) {
            byte[][] byArrayArray = new byte[n][];
            System.arraycopy(this.data, 0, byArrayArray, 0, Math.min(this.data.length, byArrayArray.length));
            for (int i = this.data.length; i < n; ++i) {
                byArrayArray[i] = FileObjectMemory.getCompressedEmptyBlock();
            }
            this.data = byArrayArray;
        }
    }

    private void readWrite(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        long l = this.pos + (long)n2;
        if (l > this.length) {
            if (bl) {
                this.changeLength(l);
            } else {
                if (n2 == 0) {
                    return;
                }
                throw new EOFException("File: " + this.name);
            }
        }
        while (n2 > 0) {
            int n3 = (int)Math.min((long)n2, 65536L - (this.pos & 0xFFFFL));
            int n4 = (int)(this.pos >>> 16);
            FileObjectMemory.expand(this.data, n4);
            byte[] byArray2 = this.data[n4];
            int n5 = (int)(this.pos & 0xFFFFL);
            if (bl) {
                System.arraycopy(byArray, n, byArray2, n5, n3);
            } else {
                System.arraycopy(byArray2, n5, byArray, n, n3);
            }
            if (this.compress) {
                FileObjectMemory.compressLater(this.data, n4);
            }
            n += n3;
            this.pos += (long)n3;
            n2 -= n3;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.touch();
        this.readWrite(byArray, n, n2, true);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.readWrite(byArray, n, n2, false);
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void close() {
        this.pos = 0L;
    }

    public void sync() {
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    static {
        COMPRESS_LATER = new Cache(8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 5549197956072850355L;
        private int size;

        Cache(int n) {
            super(n, 0.75f, true);
            this.size = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            if (this.size() < this.size) {
                return false;
            }
            CompressItem compressItem = (CompressItem)entry.getKey();
            FileObjectMemory.compress(compressItem.data, compressItem.page);
            return true;
        }
    }

    static class CompressItem {
        byte[][] data;
        int page;

        CompressItem() {
        }

        public int hashCode() {
            return this.data.hashCode() ^ this.page;
        }

        public boolean equals(Object object) {
            if (object instanceof CompressItem) {
                CompressItem compressItem = (CompressItem)object;
                return compressItem.data == this.data && compressItem.page == this.page;
            }
            return false;
        }
    }
}

