/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TcpFailureDetector
extends ChannelInterceptorBase {
    private static final Log log = LogFactory.getLog(TcpFailureDetector.class);
    protected static byte[] TCP_FAIL_DETECT = new byte[]{79, -89, 115, 72, 121, -126, 67, -55, -97, 111, -119, -128, -95, 91, 7, 20, 125, -39, 82, 91, -21, -15, 67, -102, -73, 126, -66, -113, -127, 103, 30, -74, 55, 21, -66, -121, 69, 126, 76, -88, -65, 10, 77, 19, 83, 56, 21, 50, 85, -10, -108, -73, 58, -6, 64, 120, -111, 4, 125, -41, 114, -124, -64, -43};
    protected boolean performConnectTest = true;
    protected long connectTimeout = 1000L;
    protected boolean performSendTest = true;
    protected boolean performReadTest = false;
    protected long readTestTimeout = 5000L;
    protected Membership membership = null;
    protected HashMap<Member, Long> removeSuspects = new HashMap();
    protected HashMap<Member, Long> addSuspects = new HashMap();

    /*
     * Unable to fully structure code
     */
    @Override
    public void sendMessage(Member[] destination, ChannelMessage msg, InterceptorPayload payload) throws ChannelException {
        block4: {
            try {
                super.sendMessage(destination, msg, payload);
                break block4;
            }
            catch (ChannelException cx) {
                mbrs = cx.getFaultyMembers();
                i = 0;
                ** while (i < mbrs.length)
            }
lbl-1000:
            // 1 sources

            {
                if (mbrs[i].getCause() != null && !(mbrs[i].getCause() instanceof RemoteProcessException)) {
                    this.memberDisappeared(mbrs[i].getMember());
                }
                ++i;
                continue;
            }
lbl12:
            // 1 sources

            throw cx;
        }
    }

    @Override
    public void messageReceived(ChannelMessage msg) {
        boolean process = true;
        if (this.okToProcess(msg.getOptions())) {
            boolean bl = process = msg.getMessage().getLength() != TCP_FAIL_DETECT.length || !Arrays.equals(TCP_FAIL_DETECT, msg.getMessage().getBytes());
        }
        if (process) {
            super.messageReceived(msg);
        } else if (log.isDebugEnabled()) {
            log.debug("Received a failure detector packet:" + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberAdded(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        boolean notify = false;
        Membership membership = this.membership;
        synchronized (membership) {
            if (this.removeSuspects.containsKey(member)) {
                this.removeSuspects.remove(member);
            } else if (this.membership.getMember(member) == null) {
                if (this.memberAlive(member)) {
                    this.membership.memberAlive((MemberImpl)member);
                    notify = true;
                } else {
                    this.addSuspects.put(member, System.currentTimeMillis());
                }
            }
        }
        if (notify) {
            super.memberAdded(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDisappeared(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        boolean notify = false;
        boolean shutdown = Arrays.equals(member.getCommand(), Member.SHUTDOWN_PAYLOAD);
        if (!shutdown && log.isInfoEnabled()) {
            log.info("Received memberDisappeared[" + member + "] message. Will verify.");
        }
        Membership membership = this.membership;
        synchronized (membership) {
            if (!this.membership.contains(member)) {
                if (log.isInfoEnabled()) {
                    log.info("Verification complete. Member already disappeared[" + member + "]");
                }
                return;
            }
            if (shutdown || !this.memberAlive(member)) {
                this.membership.removeMember((MemberImpl)member);
                this.removeSuspects.remove(member);
                notify = true;
            } else {
                this.removeSuspects.put(member, System.currentTimeMillis());
            }
        }
        if (notify) {
            if (log.isInfoEnabled()) {
                log.info("Verification complete. Member disappeared[" + member + "]");
            }
            super.memberDisappeared(member);
        } else if (log.isInfoEnabled()) {
            log.info("Verification complete. Member still alive[" + member + "]");
        }
    }

    @Override
    public boolean hasMembers() {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.hasMembers();
    }

    @Override
    public Member[] getMembers() {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.getMembers();
    }

    @Override
    public Member getMember(Member mbr) {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.getMember(mbr);
    }

    @Override
    public Member getLocalMember(boolean incAlive) {
        return super.getLocalMember(incAlive);
    }

    @Override
    public void heartbeat() {
        super.heartbeat();
        this.checkMembers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMembers(boolean checkAll) {
        try {
            if (this.membership == null) {
                this.setupMembership();
            }
            Membership membership = this.membership;
            synchronized (membership) {
                if (!checkAll) {
                    this.performBasicCheck();
                } else {
                    this.performForcedCheck();
                }
            }
        }
        catch (Exception x) {
            log.warn("Unable to perform heartbeat on the TcpFailureDetector.", x);
        }
    }

    protected void performForcedCheck() {
        Member[] members = super.getMembers();
        int i = 0;
        while (members != null && i < members.length) {
            if (this.memberAlive(members[i])) {
                if (this.membership.memberAlive((MemberImpl)members[i])) {
                    super.memberAdded(members[i]);
                }
                this.addSuspects.remove(members[i]);
            } else if (this.membership.getMember(members[i]) != null) {
                this.membership.removeMember((MemberImpl)members[i]);
                this.removeSuspects.remove(members[i]);
                super.memberDisappeared(members[i]);
            }
            ++i;
        }
    }

    protected void performBasicCheck() {
        MemberImpl m;
        Member[] members = super.getMembers();
        int i = 0;
        while (members != null && i < members.length) {
            if (this.membership.memberAlive((MemberImpl)members[i])) {
                if (this.memberAlive(members[i])) {
                    log.warn("Member added, even though we werent notified:" + members[i]);
                    super.memberAdded(members[i]);
                } else {
                    this.membership.removeMember((MemberImpl)members[i]);
                }
            }
            ++i;
        }
        MemberImpl[] keys = this.removeSuspects.keySet().toArray(new MemberImpl[this.removeSuspects.size()]);
        int i2 = 0;
        while (i2 < keys.length) {
            m = keys[i2];
            if (this.membership.getMember(m) != null && !this.memberAlive(m)) {
                this.membership.removeMember(m);
                super.memberDisappeared(m);
                this.removeSuspects.remove(m);
                if (log.isInfoEnabled()) {
                    log.info("Suspect member, confirmed dead.[" + m + "]");
                }
            }
            ++i2;
        }
        keys = this.addSuspects.keySet().toArray(new MemberImpl[this.addSuspects.size()]);
        i2 = 0;
        while (i2 < keys.length) {
            m = keys[i2];
            if (this.membership.getMember(m) == null && this.memberAlive(m)) {
                this.membership.memberAlive(m);
                super.memberAdded(m);
                this.addSuspects.remove(m);
                if (log.isInfoEnabled()) {
                    log.info("Suspect member, confirmed alive.[" + m + "]");
                }
            }
            ++i2;
        }
    }

    protected synchronized void setupMembership() {
        if (this.membership == null) {
            this.membership = new Membership((MemberImpl)super.getLocalMember(true));
        }
    }

    protected boolean memberAlive(Member mbr) {
        return TcpFailureDetector.memberAlive(mbr, TCP_FAIL_DETECT, this.performSendTest, this.performReadTest, this.readTestTimeout, this.connectTimeout, this.getOptionFlag());
    }

    /*
     * Exception decompiling
     */
    protected static boolean memberAlive(Member mbr, byte[] msgData, boolean sendTest, boolean readTest, long readTimeout, long conTimeout, int optionFlag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean getPerformConnectTest() {
        return this.performConnectTest;
    }

    public long getReadTestTimeout() {
        return this.readTestTimeout;
    }

    public boolean getPerformSendTest() {
        return this.performSendTest;
    }

    public boolean getPerformReadTest() {
        return this.performReadTest;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setPerformConnectTest(boolean performConnectTest) {
        this.performConnectTest = performConnectTest;
    }

    public void setPerformReadTest(boolean performReadTest) {
        this.performReadTest = performReadTest;
    }

    public void setPerformSendTest(boolean performSendTest) {
        this.performSendTest = performSendTest;
    }

    public void setReadTestTimeout(long readTestTimeout) {
        this.readTestTimeout = readTestTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

