/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.xml.ws.WebServiceRef;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class DefaultInstanceManager
implements InstanceManager {
    private final javax.naming.Context context;
    private final Map<String, Map<String, String>> injectionMap;
    protected final ClassLoader classLoader;
    protected final ClassLoader containerClassLoader;
    protected boolean privileged;
    protected boolean ignoreAnnotations;
    private Properties restrictedFilters = new Properties();
    private Properties restrictedListeners = new Properties();
    private Properties restrictedServlets = new Properties();

    public DefaultInstanceManager(javax.naming.Context context, Map<String, Map<String, String>> injectionMap, Context catalinaContext, ClassLoader containerClassLoader) {
        InputStream is;
        this.classLoader = catalinaContext.getLoader().getClassLoader();
        this.privileged = catalinaContext.getPrivileged();
        this.containerClassLoader = containerClassLoader;
        this.ignoreAnnotations = catalinaContext.getIgnoreAnnotations();
        StringManager sm = StringManager.getManager("org.apache.catalina.core");
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedServlets.properties");
            if (is != null) {
                this.restrictedServlets.load(is);
            } else {
                catalinaContext.getLogger().error(sm.getString("defaultInstanceManager.restrictedServletsResource"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error(sm.getString("defaultInstanceManager.restrictedServletsResource"), e);
        }
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedListeners.properties");
            if (is != null) {
                this.restrictedListeners.load(is);
            } else {
                catalinaContext.getLogger().error(sm.getString("defaultInstanceManager.restrictedListenersResources"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error(sm.getString("defaultInstanceManager.restrictedListenersResources"), e);
        }
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedFilters.properties");
            if (is != null) {
                this.restrictedFilters.load(is);
            } else {
                catalinaContext.getLogger().error(sm.getString("defaultInstanceManager.restrictedFiltersResources"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error(sm.getString("defaultInstanceManager.restrictedServletsResources"), e);
        }
        this.context = context;
        this.injectionMap = injectionMap;
    }

    @Override
    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = this.loadClassMaybePrivileged(className, this.classLoader);
        return this.newInstance(clazz.newInstance(), clazz);
    }

    @Override
    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, NamingException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        return this.newInstance(clazz.newInstance(), clazz);
    }

    @Override
    public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
        this.newInstance(o, o.getClass());
    }

    private Object newInstance(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (!this.ignoreAnnotations) {
            Map<String, String> injections = this.injectionMap.get(clazz.getName());
            this.processAnnotations(instance, injections);
            this.postConstruct(instance, clazz);
        }
        return instance;
    }

    @Override
    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        if (!this.ignoreAnnotations) {
            this.preDestroy(instance, instance.getClass());
        }
    }

    protected void postConstruct(Object instance, final Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.postConstruct(instance, superClass);
        }
        Method[] methods = null;
        methods = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        }) : clazz.getDeclaredMethods();
        AccessibleObject postConstruct = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(PostConstruct.class)) {
                if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PostConstruct annotation");
                }
                postConstruct = method;
            }
            ++n2;
        }
        if (postConstruct != null) {
            boolean accessibility = postConstruct.isAccessible();
            ((Method)postConstruct).setAccessible(true);
            ((Method)postConstruct).invoke(instance, new Object[0]);
            ((Method)postConstruct).setAccessible(accessibility);
        }
    }

    protected void preDestroy(Object instance, final Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.preDestroy(instance, superClass);
        }
        Method[] methods = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        }) : clazz.getDeclaredMethods();
        AccessibleObject preDestroy = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(PreDestroy.class)) {
                if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PreDestroy annotation");
                }
                preDestroy = method;
                break;
            }
            ++n2;
        }
        if (preDestroy != null) {
            boolean accessibility = preDestroy.isAccessible();
            ((Method)preDestroy).setAccessible(true);
            ((Method)preDestroy).invoke(instance, new Object[0]);
            ((Method)preDestroy).setAccessible(accessibility);
        }
    }

    protected void processAnnotations(Object instance, Map<String, String> injections) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        Class<?> clazz = instance.getClass();
        while (clazz != null) {
            Field[] fields = null;
            if (Globals.IS_SECURITY_ENABLED) {
                final Class<?> clazz2 = clazz;
                fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                    @Override
                    public Field[] run() {
                        return clazz2.getDeclaredFields();
                    }
                });
            } else {
                fields = clazz.getDeclaredFields();
            }
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation;
                Field field = fieldArray[n2];
                if (injections != null && injections.containsKey(field.getName())) {
                    DefaultInstanceManager.lookupFieldResource(this.context, instance, field, injections.get(field.getName()), clazz);
                } else if (field.isAnnotationPresent(Resource.class)) {
                    annotation = field.getAnnotation(Resource.class);
                    DefaultInstanceManager.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                } else if (field.isAnnotationPresent(EJB.class)) {
                    annotation = field.getAnnotation(EJB.class);
                    DefaultInstanceManager.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                } else if (field.isAnnotationPresent(WebServiceRef.class)) {
                    annotation = field.getAnnotation(WebServiceRef.class);
                    DefaultInstanceManager.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                } else if (field.isAnnotationPresent(PersistenceContext.class)) {
                    annotation = field.getAnnotation(PersistenceContext.class);
                    DefaultInstanceManager.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                } else if (field.isAnnotationPresent(PersistenceUnit.class)) {
                    annotation = field.getAnnotation(PersistenceUnit.class);
                    DefaultInstanceManager.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                }
                ++n2;
            }
            Method[] methods = null;
            if (Globals.IS_SECURITY_ENABLED) {
                final Class<?> clazz2 = clazz;
                methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return clazz2.getDeclaredMethods();
                    }
                });
            } else {
                methods = clazz.getDeclaredMethods();
            }
            Method[] methodArray = methods;
            int n3 = methods.length;
            n = 0;
            while (n < n3) {
                Annotation annotation;
                String fieldName;
                Method method = methodArray[n];
                String methodName = method.getName();
                if (injections != null && methodName.startsWith("set") && methodName.length() > 3 && injections.containsKey(fieldName = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4))) {
                    DefaultInstanceManager.lookupMethodResource(this.context, instance, method, injections.get(fieldName), clazz);
                    break;
                }
                if (method.isAnnotationPresent(Resource.class)) {
                    annotation = method.getAnnotation(Resource.class);
                    DefaultInstanceManager.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                } else if (method.isAnnotationPresent(EJB.class)) {
                    annotation = method.getAnnotation(EJB.class);
                    DefaultInstanceManager.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                } else if (method.isAnnotationPresent(WebServiceRef.class)) {
                    annotation = method.getAnnotation(WebServiceRef.class);
                    DefaultInstanceManager.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                } else if (method.isAnnotationPresent(PersistenceContext.class)) {
                    annotation = method.getAnnotation(PersistenceContext.class);
                    DefaultInstanceManager.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                } else if (method.isAnnotationPresent(PersistenceUnit.class)) {
                    annotation = method.getAnnotation(PersistenceUnit.class);
                    DefaultInstanceManager.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
    }

    protected Class<?> loadClassMaybePrivileged(final String className, final ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws Exception {
                        return DefaultInstanceManager.this.loadClass(className, classLoader);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)t;
                }
                throw new RuntimeException(t);
            }
        } else {
            clazz = this.loadClass(className, classLoader);
        }
        this.checkAccess(clazz);
        return clazz;
    }

    protected Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className.startsWith("org.apache.catalina")) {
            return this.containerClassLoader.loadClass(className);
        }
        try {
            Class<?> clazz = this.containerClassLoader.loadClass(className);
            if (ContainerServlet.class.isAssignableFrom(clazz)) {
                return clazz;
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
        return classLoader.loadClass(className);
    }

    private void checkAccess(Class<?> clazz) {
        if (this.privileged) {
            return;
        }
        if (Filter.class.isAssignableFrom(clazz)) {
            this.checkAccess(clazz, this.restrictedFilters);
        } else if (Servlet.class.isAssignableFrom(clazz)) {
            this.checkAccess(clazz, this.restrictedServlets);
        } else {
            this.checkAccess(clazz, this.restrictedListeners);
        }
    }

    private void checkAccess(Class<?> clazz, Properties restricted) {
        while (clazz != null) {
            if ("restricted".equals(restricted.getProperty(clazz.getName()))) {
                throw new SecurityException("Restricted class" + clazz);
            }
            clazz = clazz.getSuperclass();
        }
    }

    protected static void lookupFieldResource(javax.naming.Context context, Object instance, Field field, String name, Class<?> clazz) throws NamingException, IllegalAccessException {
        String normalizedName = DefaultInstanceManager.normalize(name);
        Object lookedupResource = normalizedName != null && normalizedName.length() > 0 ? context.lookup(normalizedName) : context.lookup(String.valueOf(clazz.getName()) + "/" + field.getName());
        boolean accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(instance, lookedupResource);
        field.setAccessible(accessibility);
    }

    protected static void lookupMethodResource(javax.naming.Context context, Object instance, Method method, String name, Class<?> clazz) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getName().length() < 4 || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        String normalizedName = DefaultInstanceManager.normalize(name);
        Object lookedupResource = normalizedName != null && normalizedName.length() > 0 ? context.lookup(normalizedName) : context.lookup(String.valueOf(clazz.getName()) + "/" + DefaultInstanceManager.getName(method));
        boolean accessibility = method.isAccessible();
        method.setAccessible(true);
        method.invoke(instance, lookedupResource);
        method.setAccessible(accessibility);
    }

    public static String getName(Method setter) {
        StringBuilder name = new StringBuilder(setter.getName());
        name.delete(0, 3);
        name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        return name.toString();
    }

    private static String normalize(String jndiName) {
        if (jndiName != null && jndiName.startsWith("java:comp/env/")) {
            return jndiName.substring(14);
        }
        return jndiName;
    }
}

