/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;

public final class ConfigurationElementMemento
implements IMemento {
    private IConfigurationElement configurationElement;

    public ConfigurationElementMemento(IConfigurationElement configurationElement) {
        if (configurationElement == null) {
            throw new NullPointerException();
        }
        this.configurationElement = configurationElement;
    }

    @Override
    public IMemento createChild(String type) {
        return null;
    }

    @Override
    public IMemento createChild(String type, String id) {
        return null;
    }

    @Override
    public IMemento getChild(String type) {
        IConfigurationElement[] configurationElements = this.configurationElement.getChildren(type);
        if (configurationElements != null && configurationElements.length >= 1) {
            return new ConfigurationElementMemento(configurationElements[0]);
        }
        return null;
    }

    @Override
    public IMemento[] getChildren() {
        IConfigurationElement[] configurationElements = this.configurationElement.getChildren();
        return this.getMementoArray(configurationElements);
    }

    @Override
    public IMemento[] getChildren(String type) {
        IConfigurationElement[] configurationElements = this.configurationElement.getChildren(type);
        return this.getMementoArray(configurationElements);
    }

    private IMemento[] getMementoArray(IConfigurationElement[] configurationElements) {
        if (configurationElements != null && configurationElements.length > 0) {
            IMemento[] mementos = new ConfigurationElementMemento[configurationElements.length];
            int i = 0;
            while (i < configurationElements.length) {
                mementos[i] = new ConfigurationElementMemento(configurationElements[i]);
                ++i;
            }
            return mementos;
        }
        return new IMemento[0];
    }

    @Override
    public Float getFloat(String key) {
        String string = this.configurationElement.getAttribute(key);
        if (string != null) {
            try {
                return new Float(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    @Override
    public String getType() {
        return this.configurationElement.getName();
    }

    @Override
    public String getID() {
        return this.configurationElement.getAttribute("IMemento.internal.id");
    }

    @Override
    public Integer getInteger(String key) {
        String string = this.configurationElement.getAttribute(key);
        if (string != null) {
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    @Override
    public String getString(String key) {
        return this.configurationElement.getAttribute(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        String string = this.configurationElement.getAttribute(key);
        if (string == null) {
            return null;
        }
        return Boolean.valueOf(string);
    }

    @Override
    public String getTextData() {
        return this.configurationElement.getValue();
    }

    @Override
    public String[] getAttributeKeys() {
        return this.configurationElement.getAttributeNames();
    }

    @Override
    public void putFloat(String key, float value) {
    }

    @Override
    public void putInteger(String key, int value) {
    }

    @Override
    public void putMemento(IMemento memento) {
    }

    @Override
    public void putString(String key, String value) {
    }

    @Override
    public void putBoolean(String key, boolean value) {
    }

    @Override
    public void putTextData(String data) {
    }

    public String getContributorName() {
        return this.configurationElement.getContributor().getName();
    }

    public String getExtensionID() {
        return this.configurationElement.getDeclaringExtension().getUniqueIdentifier();
    }
}

