/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.shellkit;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.CssBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.internal.theme.WidgetMatcher;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.widgets.controlkit.ControlThemeAdapterImpl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ShellThemeAdapter
extends ControlThemeAdapterImpl {
    private static final int MENU_BAR_MIN_HEIGHT = 20;

    @Override
    protected void configureMatcher(WidgetMatcher matcher) {
        super.configureMatcher(matcher);
        matcher.addStyle("TITLE", 32);
        matcher.addStyle("APPLICATION_MODAL", 65536);
        matcher.addStyle("TOOL", 4);
        matcher.addStyle("SHEET", 0x10000000);
        matcher.addState("maximized", new WidgetMatcher.Constraint(){

            @Override
            public boolean matches(Widget widget) {
                return ((Shell)widget).getMaximized();
            }
        });
    }

    public BoxDimensions getTitleBarMargin(Shell shell) {
        if ((shell.getStyle() & 0x20) != 0) {
            return this.getCssBoxDimensions((String)"Shell-Titlebar", (String)"margin", (Widget)shell).dimensions;
        }
        return CssBoxDimensions.ZERO.dimensions;
    }

    public int getTitleBarHeight(Shell shell) {
        int result = 0;
        if ((shell.getStyle() & 0x20) != 0) {
            result = this.getCssDimension("Shell-Titlebar", "height", shell);
        }
        return result;
    }

    public int getMenuBarHeight(Shell shell) {
        int result = 0;
        if (shell.getMenuBar() != null) {
            Font font = this.getCssFont("Shell", "font", shell);
            int fontHeight = TextSizeUtil.getCharHeight(font);
            BoxDimensions padding = ShellThemeAdapter.getMenuBarItemPadding();
            result = Math.max(20, fontHeight + padding.top + padding.bottom);
        }
        return result;
    }

    private static BoxDimensions getMenuBarItemPadding() {
        SimpleSelector selector = new SimpleSelector(":onMenuBar");
        CssValue cssValue = ThemeUtil.getCssValue("MenuItem", "padding", selector);
        return ((CssBoxDimensions)cssValue).dimensions;
    }
}

