/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;

public class DisplayRealm
extends Realm {
    final Display display;

    public static Realm getRealm(Display display) {
        return SWTObservables.getRealm(display);
    }

    DisplayRealm(Display display) {
        this.display = display;
    }

    public boolean isCurrent() {
        return Display.getCurrent() == this.display;
    }

    public void asyncExec(final Runnable runnable) {
        Runnable safeRunnable = new Runnable(){

            @Override
            public void run() {
                DisplayRealm.safeRun((Runnable)runnable);
            }
        };
        if (!this.display.isDisposed()) {
            this.display.asyncExec(safeRunnable);
        }
    }

    public void timerExec(int milliseconds, final Runnable runnable) {
        if (!this.display.isDisposed()) {
            Runnable safeRunnable = new Runnable(){

                @Override
                public void run() {
                    DisplayRealm.safeRun((Runnable)runnable);
                }
            };
            this.display.timerExec(milliseconds, safeRunnable);
        }
    }

    public int hashCode() {
        return this.display == null ? 0 : this.display.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DisplayRealm other = (DisplayRealm)((Object)obj);
        return !(this.display == null ? other.display != null : !this.display.equals(other.display));
    }
}

