/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.CommandRunner;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.AbstractExecutable;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.w3c.dom.Node;

public class CheatSheetCommand
extends AbstractExecutable {
    private String serialization;
    private String returns;
    private boolean serializationFound;

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public String getSerialization() {
        return this.serialization;
    }

    @Override
    public boolean isCheatSheetManagerUsed() {
        return true;
    }

    @Override
    public IStatus execute(CheatSheetManager csm) {
        return new CommandRunner().executeCommand(this, csm);
    }

    @Override
    public boolean hasParams() {
        return false;
    }

    @Override
    public boolean handleAttribute(Node attribute) {
        if ("serialization".equals(attribute.getNodeName())) {
            this.setSerialization(attribute.getNodeValue());
            this.serializationFound = true;
            return true;
        }
        if ("returns".equals(attribute.getNodeName())) {
            this.setReturns(attribute.getNodeValue());
            return true;
        }
        return false;
    }

    @Override
    public String checkAttributes(Node node) {
        if (!this.serializationFound) {
            return NLS.bind((String)Messages.get().ERROR_PARSING_NO_SERIALIZATION, (Object[])new Object[]{node.getNodeName()});
        }
        if (this.isConfirm() && !this.isRequired()) {
            return NLS.bind((String)Messages.get().ERROR_PARSING_REQUIRED_CONFIRM, (Object[])new Object[]{node.getNodeName()});
        }
        return null;
    }

    public void setReturns(String returns) {
        this.returns = returns;
    }

    public String getReturns() {
        return this.returns;
    }
}

