/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.groupkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.groupkit.GroupOperationHandler;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Widget;

public class GroupLCA
extends WidgetLCA<Group> {
    public static final GroupLCA INSTANCE = new GroupLCA();
    private static final String TYPE = "rwt.widgets.Group";
    private static final String[] ALLOWED_STYLES = new String[]{"SHADOW_ETCHED_IN", "SHADOW_ETCHED_OUT", "SHADOW_IN", "SHADOW_OUT", "SHADOW_NONE", "NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";

    @Override
    public void preserveValues(Group group) {
        WidgetLCAUtil.preserveProperty((Widget)group, PROP_TEXT, group.getText());
    }

    @Override
    public void renderInitialization(Group group) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(group, TYPE);
        remoteObject.setHandler(new GroupOperationHandler(group));
        remoteObject.set("parent", WidgetUtil.getId(group.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(group, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(Group group) throws IOException {
        ControlLCAUtil.renderChanges(group);
        WidgetLCAUtil.renderCustomVariant(group);
        GroupLCA.renderText(group);
        GroupLCA.renderMnemonicIndex(group);
    }

    private static void renderText(Group group) {
        String newValue = group.getText();
        if (WidgetLCAUtil.hasChanged(group, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            RemoteObjectFactory.getRemoteObject(group).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(Group group) {
        int mnemonicIndex;
        String text = group.getText();
        if (WidgetLCAUtil.hasChanged(group, PROP_TEXT, text, "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            RemoteObjectFactory.getRemoteObject(group).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }

    private GroupLCA() {
    }
}

