/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

public final class WorkbenchLogger
extends Logger {
    protected DebugTrace trace;
    protected FrameworkLog log;
    private String bundleName;

    @Inject
    public WorkbenchLogger(@Optional @Named(value="logger.bundlename") String bundleName) {
        this.bundleName = bundleName == null ? "org.eclipse.e4.ui.workbench" : bundleName;
    }

    public void debug(Throwable t) {
        this.debug(t, null);
    }

    public void debug(Throwable t, String message) {
        this.trace(t, message);
    }

    public void error(Throwable t, String message) {
        this.log((IStatus)new Status(4, this.bundleName, message, t));
    }

    private static FrameworkLogEntry getLog(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(WorkbenchLogger.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                childlist.add(WorkbenchLogger.getLog(children[i]));
                ++i;
            }
        }
        children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry(status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), stackCode, t, (FrameworkLogEntry[])children);
    }

    public void info(Throwable t, String message) {
        this.log((IStatus)new Status(1, this.bundleName, message, t));
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    private void log(IStatus status) {
        if (this.log != null) {
            this.log.log(WorkbenchLogger.getLog(status));
        } else {
            System.out.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }
    }

    @Inject
    public void setDebugOptions(DebugOptions options) {
        if (options != null) {
            this.trace = options.newDebugTrace(this.bundleName, WorkbenchLogger.class);
        }
    }

    @Inject
    public void setFrameworkLog(FrameworkLog log) {
        this.log = log;
    }

    public void trace(Throwable t, String message) {
        if (this.trace != null) {
            this.trace.trace(null, message, t);
        } else {
            System.out.println(message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void warn(Throwable t, String message) {
        this.log((IStatus)new Status(2, this.bundleName, message, t));
    }
}

