/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GridLayoutExample
implements IExamplePage {
    private Composite layoutArea;
    private boolean propEqualWidth;
    private boolean propPrefSize;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        this.createLayoutArea(parent);
        this.createControlButtons(parent);
    }

    private void createLayoutArea(Composite parent) {
        if (this.layoutArea == null || this.layoutArea.isDisposed()) {
            this.layoutArea = new Composite(parent, 0);
            this.layoutArea.setLayout((Layout)ExampleUtil.createFillLayout((boolean)true));
            this.layoutArea.setLayoutData((Object)ExampleUtil.createFillData());
        }
        Control[] children = this.layoutArea.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.createLayoutComp(this.layoutArea);
        this.layoutArea.layout();
    }

    private void createLayoutComp(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        Composite layoutComp = new Composite(composite, 2048);
        if (!this.propPrefSize) {
            layoutComp.setLayoutData((Object)ExampleUtil.createFillData());
        }
        GridLayout layout = new GridLayout(3, this.propEqualWidth);
        layoutComp.setLayout((Layout)layout);
        int i = 0;
        while (i < 3) {
            Label label = new Label(layoutComp, 0);
            label.setText("Label");
            Text text = new Text(layoutComp, 2052);
            GridData textData = new GridData(4, 4, true, false);
            text.setLayoutData((Object)textData);
            Button button = new Button(layoutComp, 8);
            button.setText("Ok");
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            button.setLayoutData((Object)gridData);
            ++i;
        }
    }

    protected void createControlButtons(final Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)false, (boolean)false));
        final Button equalWidthButton = new Button(comp, 32);
        equalWidthButton.setText("Make all columns equal width");
        equalWidthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.propEqualWidth = equalWidthButton.getSelection();
                GridLayoutExample.this.createLayoutArea(parent);
            }
        });
        final Button preferredSizeButton = new Button(comp, 32);
        preferredSizeButton.setText("Shrink container to its preferred size");
        preferredSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.propPrefSize = preferredSizeButton.getSelection();
                GridLayoutExample.this.createLayoutArea(parent);
            }
        });
    }
}

