/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class FontData
implements SerializableCompatibility {
    private String name;
    private int height;
    private int style;
    private String locale;

    public FontData() {
        this("", 12, 0);
    }

    public FontData(String name, int height, int style) {
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0) {
            SWT.error(5);
        }
        this.name = name;
        this.height = height;
        this.style = FontData.checkFontStyle(style);
        this.locale = "";
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int start = 0;
        int end = string.indexOf(124);
        if (end == -1) {
            SWT.error(5);
        }
        String version1 = string.substring(start, end);
        try {
            if (Integer.parseInt(version1) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((end = string.indexOf(124, start = end + 1)) == -1) {
            SWT.error(5);
        }
        String name = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            SWT.error(5);
        }
        int height = 0;
        try {
            height = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            SWT.error(5);
        }
        int style = 0;
        try {
            style = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        this.name = name;
        this.height = height;
        this.style = style;
        this.locale = "";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("1|");
        buffer.append(this.getName());
        buffer.append("|");
        buffer.append(this.getHeight());
        buffer.append("|");
        buffer.append(this.getStyle());
        buffer.append("|");
        return buffer.toString();
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setHeight(int height) {
        if (height < 0) {
            SWT.error(5);
        }
        this.height = height;
    }

    public void setName(String name) {
        if (name == null) {
            SWT.error(4);
        }
        this.name = name;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setLocale(String locale) {
        int length;
        String result = "";
        if (locale != null && (length = locale.length()) > 0) {
            char sep = '_';
            result = locale;
            int i = 0;
            while (i < 2) {
                if (length > 0 && result.charAt(0) == sep) {
                    result = result.substring(1);
                    --length;
                }
                ++i;
            }
            if (length > 0 && result.charAt(length - 1) == sep) {
                result = result.substring(0, length - 1);
            }
        }
        this.locale = result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof FontData) {
            FontData toCompare = (FontData)obj;
            result = this.name.equals(toCompare.name) && this.height == toCompare.height && this.style == toCompare.style;
        }
        return result;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.height << 8 ^ this.style;
    }

    private static int checkFontStyle(int style) {
        int result = 0;
        if ((style & 1) != 0) {
            result |= 1;
        }
        if ((style & 2) != 0) {
            result |= 2;
        }
        return result;
    }
}

