/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.component.Dumpable;

public interface Attributes {
    public static final Attributes NULL = new Attributes(){

        @Override
        public Object removeAttribute(String name) {
            return null;
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            return null;
        }

        @Override
        public Object getAttribute(String name) {
            return null;
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return Collections.emptySet();
        }

        @Override
        public void clearAttributes() {
        }

        @Override
        public Map<String, Object> asAttributeMap() {
            return Collections.emptyMap();
        }
    };

    public Object removeAttribute(String var1);

    public Object setAttribute(String var1, Object var2);

    public Object getAttribute(String var1);

    public Set<String> getAttributeNameSet();

    default public Map<String, Object> asAttributeMap() {
        return new AbstractMap<String, Object>(){
            private final Set<String> _attributeNameSet;
            private final AbstractSet<Map.Entry<String, Object>> _entrySet;
            {
                this._attributeNameSet = Attributes.this.getAttributeNameSet();
                this._entrySet = new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        final Iterator<String> names = _attributeNameSet.iterator();
                        return new Iterator<Map.Entry<String, Object>>(){

                            @Override
                            public boolean hasNext() {
                                return names.hasNext();
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                String name = (String)names.next();
                                return new AbstractMap.SimpleEntry<String, Object>(name, Attributes.this.getAttribute(name));
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return _attributeNameSet.size();
                    }
                };
            }

            @Override
            public int size() {
                return this._attributeNameSet.size();
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this._entrySet;
            }
        };
    }

    default public void clearAttributes() {
        for (String name : this.getAttributeNameSet()) {
            this.removeAttribute(name);
        }
    }

    public static Attributes unwrap(Attributes attributes) {
        while (attributes instanceof Wrapper) {
            attributes = ((Wrapper)attributes).getWrapped();
        }
        return attributes;
    }

    public static <T extends Wrapper> T unwrap(Attributes attributes, Class<T> target) {
        while (true) {
            if (target.isAssignableFrom(attributes.getClass())) {
                return (T)((Wrapper)attributes);
            }
            if (!(attributes instanceof Wrapper)) break;
            Wrapper wrapper = (Wrapper)attributes;
            attributes = wrapper.getWrapped();
        }
        return null;
    }

    public static class Wrapper
    implements Attributes {
        private final Attributes _wrapped;

        public Wrapper(Attributes wrapped) {
            this._wrapped = Objects.requireNonNull(wrapped);
        }

        public Attributes getWrapped() {
            return this._wrapped;
        }

        @Override
        public Object removeAttribute(String name) {
            return this.getWrapped().removeAttribute(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            return this.getWrapped().setAttribute(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            return this.getWrapped().getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return this.getWrapped().getAttributeNameSet();
        }

        @Override
        public void clearAttributes() {
            this.getWrapped().clearAttributes();
        }

        public int hashCode() {
            return this.getWrapped().hashCode();
        }

        public boolean equals(Object obj) {
            return this.getWrapped().equals(obj);
        }
    }

    public static class Layer
    implements Attributes {
        private static final Object REMOVED = new Object(){

            public String toString() {
                return "REMOVED";
            }
        };
        private final Attributes _persistent;
        private final Attributes _layer;

        public Layer(Attributes persistent) {
            this(persistent, new Mapped());
        }

        public Layer(Attributes persistent, Attributes layer) {
            this._persistent = persistent;
            this._layer = layer;
        }

        public Attributes getPersistentAttributes() {
            return this._persistent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object removeAttribute(String name) {
            Object p = this._persistent.getAttribute(name);
            try {
                Object v = this._layer.setAttribute(name, REMOVED);
                if (v == REMOVED) {
                    Object var4_4 = null;
                    return var4_4;
                }
                if (v != null) {
                    Object object = v;
                    return object;
                }
                Object object = p;
                return object;
            }
            finally {
                if (p == null) {
                    this._layer.removeAttribute(name);
                }
            }
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            if (attribute == null) {
                return this.removeAttribute(name);
            }
            Object v = this._layer.setAttribute(name, attribute);
            return v == REMOVED ? null : v;
        }

        @Override
        public Object getAttribute(String name) {
            Object v = this._layer.getAttribute(name);
            if (v != null) {
                return v == REMOVED ? null : v;
            }
            return this._persistent.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(this._persistent.getAttributeNameSet());
            for (String name : this._layer.getAttributeNameSet()) {
                if (this._layer.getAttribute(name) == REMOVED) {
                    names.remove(name);
                    continue;
                }
                names.add(name);
            }
            return Collections.unmodifiableSet(names);
        }

        @Override
        public void clearAttributes() {
            this._layer.clearAttributes();
            for (String name : this._persistent.getAttributeNameSet()) {
                this._layer.setAttribute(name, REMOVED);
            }
        }

        public int hashCode() {
            int hash = 113;
            for (String name : this.getAttributeNameSet()) {
                hash += name.hashCode() ^ this.getAttribute(name).hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (o instanceof Attributes) {
                Set<String> theirs;
                Attributes a = (Attributes)o;
                Set<String> ours = this.getAttributeNameSet();
                if (!ours.equals(theirs = this.getAttributeNameSet())) {
                    return false;
                }
                for (String s : ours) {
                    if (Objects.equals(this.getAttribute(s), a.getAttribute(s))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class Lazy
    implements Attributes,
    Dumpable {
        private final AtomicReference<ConcurrentMap<String, Object>> _map = new AtomicReference();

        private ConcurrentMap<String, Object> map() {
            return this._map.get();
        }

        private ConcurrentMap<String, Object> ensureMap() {
            ConcurrentMap<String, Object> map;
            do {
                if ((map = this.map()) == null) continue;
                return map;
            } while (!this._map.compareAndSet(null, map = new ConcurrentHashMap<String, Object>()));
            return map;
        }

        @Override
        public Map<String, Object> asAttributeMap() {
            return this.ensureMap();
        }

        @Override
        public Object removeAttribute(String name) {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? null : map.remove(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            if (attribute == null) {
                return this.removeAttribute(name);
            }
            return this.ensureMap().put(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? null : map.get(name);
        }

        public Collection<Object> getAttributeEntriesSet() {
            return this.map().values();
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return Collections.unmodifiableSet(this.keySet());
        }

        @Override
        public void clearAttributes() {
            ConcurrentMap<String, Object> map = this.map();
            if (map != null) {
                map.clear();
            }
        }

        public int size() {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? 0 : map.size();
        }

        public String toString() {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? "{}" : map.toString();
        }

        private Set<String> keySet() {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? Collections.emptySet() : map.keySet();
        }

        public void addAll(Attributes attributes) {
            for (String name : attributes.getAttributeNameSet()) {
                this.setAttribute(name, attributes.getAttribute(name));
            }
        }

        @Override
        public String dump() {
            return Dumpable.dump(this);
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Dumpable.dumpObjects(out, indent, String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode()), this.map());
        }
    }

    public static class Mapped
    implements Attributes {
        private final Map<String, Object> _map;
        private final Set<String> _names;

        public Mapped() {
            this(new ConcurrentHashMap<String, Object>());
        }

        public Mapped(Map<String, Object> map) {
            this._map = Objects.requireNonNull(map);
            this._names = Collections.unmodifiableSet(this._map.keySet());
        }

        public Mapped(Mapped attributes) {
            this();
            this._map.putAll(attributes._map);
        }

        @Override
        public Map<String, Object> asAttributeMap() {
            return this._map;
        }

        @Override
        public Object removeAttribute(String name) {
            return this._map.remove(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            if (attribute == null) {
                return this._map.remove(name);
            }
            return this._map.put(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            return this._map.get(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return this._names;
        }

        @Override
        public void clearAttributes() {
            this._map.clear();
        }

        public int size() {
            return this._map.size();
        }

        public String toString() {
            return this._map.toString();
        }

        public void addAll(Attributes attributes) {
            for (String name : attributes.getAttributeNameSet()) {
                this.setAttribute(name, attributes.getAttribute(name));
            }
        }

        public Set<Map.Entry<String, Object>> getAttributeEntrySet() {
            return this._map.entrySet();
        }

        public int hashCode() {
            return this._map.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Attributes) {
                Attributes a = (Attributes)o;
                for (Map.Entry<String, Object> e : this._map.entrySet()) {
                    if (Objects.equals(e.getValue(), a.getAttribute(e.getKey()))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

