/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.internal.RWTMessages;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.StartupJson;
import org.eclipse.rap.rwt.internal.service.StartupPageTemplate;
import org.eclipse.rap.rwt.internal.theme.CssImage;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;

public class StartupPage {
    private final ApplicationContextImpl applicationContext;
    private final List<String> jsLibraries;
    private String clientJsLibrary;
    StartupPageTemplate startupPageTemplate;

    public StartupPage(ApplicationContextImpl applicationContext) {
        this.applicationContext = applicationContext;
        this.jsLibraries = new ArrayList<String>();
    }

    public void activate() {
        this.startupPageTemplate = new StartupPageTemplate();
    }

    public void deactivate() {
        this.startupPageTemplate = null;
    }

    public void setClientJsLibrary(String location) {
        this.clientJsLibrary = location;
    }

    public void addJsLibrary(String location) {
        this.jsLibraries.add(location);
    }

    public void send(HttpServletResponse response) throws IOException {
        StartupPageValueProvider valueProvider = new StartupPageValueProvider();
        StartupPage.setResponseHeaders(response);
        this.setContentSecurityPolicy(response, valueProvider.getNonceValue());
        this.startupPageTemplate.writePage(response.getWriter(), valueProvider);
    }

    static void setResponseHeaders(HttpServletResponse response) {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "max-age=0, no-cache, must-revalidate, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    void setContentSecurityPolicy(HttpServletResponse response, String nonceValue) {
        String csp = this.getCurrentEntryPointProperties().get("org.eclipse.rap.rwt.webclient.contentSecurityPolicy");
        if (csp != null) {
            response.setHeader("Content-Security-Policy", csp.replaceAll("nonce-", "nonce-" + nonceValue));
        }
    }

    protected void writeTitle(PrintWriter printWriter) {
        this.writeEntryPointProperty(printWriter, "org.eclipse.rap.rwt.webclient.pageTitle");
    }

    protected void writeBody(PrintWriter printWriter) {
        this.writeEntryPointProperty(printWriter, "org.eclipse.rap.rwt.webclient.bodyHtml");
    }

    protected void writeHead(PrintWriter printWriter) {
        Map<String, String> properties = this.getCurrentEntryPointProperties();
        String favIcon = properties.get("org.eclipse.rap.rwt.webclient.favicon");
        if (favIcon != null && favIcon.length() > 0) {
            String pattern = "<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"%1$s\" />";
            String favIocnMarkup = String.format(pattern, this.getResourceLocation(favIcon));
            printWriter.write(favIocnMarkup);
        }
        this.writeEntryPointProperty(printWriter, "org.eclipse.rap.rwt.webclient.additionalHeaders");
    }

    private void writeLibraries(PrintWriter printWriter, String nonceValue) {
        this.writeScriptTag(printWriter, this.clientJsLibrary, nonceValue);
        for (String location : this.jsLibraries) {
            this.writeScriptTag(printWriter, location, nonceValue);
        }
    }

    protected void writeScriptTag(PrintWriter printWriter, String libraryLocation, String nonceValue) {
        if (libraryLocation != null) {
            printWriter.write("    <script type=\"text/javascript\" src=\"");
            printWriter.write(libraryLocation);
            printWriter.write("\" nonce=\"");
            printWriter.write(nonceValue);
            printWriter.write("\" charset=\"");
            printWriter.write("UTF-8");
            printWriter.write("\"></script>\n");
        }
    }

    protected void writeBackgroundImage(PrintWriter printWriter) {
        printWriter.write(this.getBackgroundImageLocation());
    }

    protected void writeNoScriptMessage(PrintWriter printWriter) {
        String message = RWTMessages.getMessage("NoScriptWarning", ContextProvider.getRequest().getLocale());
        printWriter.write(message);
    }

    protected void writeAppScript(PrintWriter printWriter) {
        StringBuilder code = new StringBuilder();
        code.append("rwt.remote.MessageProcessor.processMessage( ");
        code.append(StartupJson.get());
        code.append(");");
        printWriter.write(code.toString());
    }

    protected String getBackgroundImageLocation() {
        String resourceName = this.getBrackgroundImage().getResourcePath(this.applicationContext);
        return resourceName != null ? this.getResourceLocation(resourceName) : "";
    }

    protected CssImage getBrackgroundImage() {
        String servletPath = ContextProvider.getRequest().getServletPath();
        return (CssImage)ThemeUtil.getCssValue(ThemeUtil.getThemeIdFor(servletPath), "Display", "background-image", SimpleSelector.DEFAULT, null);
    }

    private Map<String, String> getCurrentEntryPointProperties() {
        EntryPointManager entryPointManager = this.applicationContext.getEntryPointManager();
        return entryPointManager.getEntryPointRegistration(ContextProvider.getRequest()).getProperties();
    }

    private String getResourceLocation(String resourceName) {
        return this.applicationContext.getResourceManager().getLocation(resourceName);
    }

    private void writeEntryPointProperty(PrintWriter printWriter, String property) {
        String title = this.getCurrentEntryPointProperties().get(property);
        if (title != null) {
            printWriter.write(title);
        }
    }

    private class StartupPageValueProvider
    implements StartupPageTemplate.VariableWriter {
        private final String nonceValue = UUID.randomUUID().toString().replaceAll("-", "");

        String getNonceValue() {
            return this.nonceValue;
        }

        @Override
        public void writeVariable(PrintWriter printWriter, String variableName) {
            if (variableName.equals("libraries")) {
                StartupPage.this.writeLibraries(printWriter, this.nonceValue);
            } else if (variableName.equals("title")) {
                StartupPage.this.writeTitle(printWriter);
            } else if (variableName.equals("body")) {
                StartupPage.this.writeBody(printWriter);
            } else if (variableName.equals("headers")) {
                StartupPage.this.writeHead(printWriter);
            } else if (variableName.equals("backgroundImage")) {
                StartupPage.this.writeBackgroundImage(printWriter);
            } else if (variableName.equals("noScriptMessage")) {
                StartupPage.this.writeNoScriptMessage(printWriter);
            } else if (variableName.equals("appScript")) {
                StartupPage.this.writeAppScript(printWriter);
            } else if (variableName.equals("nonceValue")) {
                printWriter.write(this.nonceValue);
            } else {
                throw new IllegalArgumentException("Unsupported variable: " + variableName);
            }
        }
    }
}

