/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tooltipkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IToolTipAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.tooltipkit.ToolTipOperationHandler;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

public final class ToolTipLCA
extends WidgetLCA<ToolTip> {
    public static final ToolTipLCA INSTANCE = new ToolTipLCA();
    private static final String TYPE = "rwt.widgets.ToolTip";
    private static final String[] ALLOWED_STYLES = new String[]{"BALLOON", "ICON_ERROR", "ICON_INFORMATION", "ICON_WARNING"};
    private static final String PROP_AUTO_HIDE = "autoHide";
    private static final String PROP_TEXT = "text";
    private static final String PROP_MESSAGE = "message";
    private static final String PROP_LOCATION = "location";
    private static final String PROP_VISIBLE = "visible";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final Point DEFAULT_LOCATION = new Point(0, 0);

    @Override
    public void preserveValues(ToolTip toolTip) {
        WidgetLCAUtil.preserveRoundedBorder(toolTip);
        WidgetLCAUtil.preserveBackgroundGradient(toolTip);
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_AUTO_HIDE, toolTip.getAutoHide());
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_TEXT, toolTip.getText());
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_MESSAGE, toolTip.getMessage());
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_LOCATION, ToolTipLCA.getLocation(toolTip));
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_VISIBLE, toolTip.isVisible());
    }

    @Override
    public void renderInitialization(ToolTip toolTip) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(toolTip, TYPE);
        remoteObject.setHandler(new ToolTipOperationHandler(toolTip));
        remoteObject.set("parent", WidgetUtil.getId(toolTip.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(toolTip, ALLOWED_STYLES)));
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_MARKUP_ENABLED, MarkupUtil.isMarkupEnabledFor(toolTip), false);
    }

    @Override
    public void renderChanges(ToolTip toolTip) throws IOException {
        WidgetLCAUtil.renderCustomVariant(toolTip);
        WidgetLCAUtil.renderRoundedBorder(toolTip);
        WidgetLCAUtil.renderBackgroundGradient(toolTip);
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_AUTO_HIDE, toolTip.getAutoHide(), false);
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_TEXT, toolTip.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_MESSAGE, toolTip.getMessage(), "");
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_LOCATION, ToolTipLCA.getLocation(toolTip), DEFAULT_LOCATION);
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_VISIBLE, toolTip.isVisible(), false);
        WidgetLCAUtil.renderListenSelection(toolTip);
    }

    private static Point getLocation(ToolTip toolTip) {
        return toolTip.getAdapter(IToolTipAdapter.class).getLocation();
    }

    private ToolTipLCA() {
    }
}

