/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.filedialog.demo.examples;

import java.io.File;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.fileupload.DiskFileUploadReceiver;
import org.eclipse.rap.fileupload.FileDetails;
import org.eclipse.rap.fileupload.FileUploadEvent;
import org.eclipse.rap.fileupload.FileUploadHandler;
import org.eclipse.rap.fileupload.FileUploadListener;
import org.eclipse.rap.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.rap.rwt.widgets.DialogUtil;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileUploadExamplePage
implements IExamplePage {
    private static final String INITIAL_TEXT = "no files uploaded.";
    private FileUpload fileUpload;
    private Label fileNameLabel;
    private Button uploadButton;
    private Text logText;
    private ServerPushSession pushSession;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)3));
        Control controlsColumn = this.createControlsColumn(parent);
        controlsColumn.setLayoutData((Object)ExampleUtil.createFillData());
        Control serverColumn = this.createLogColumn(parent);
        serverColumn.setLayoutData((Object)ExampleUtil.createFillData());
        Control infoColumn = FileUploadExamplePage.createInfoColumn(parent);
        infoColumn.setLayoutData((Object)ExampleUtil.createFillData());
    }

    private Control createControlsColumn(Composite parent) {
        Composite column = new Composite(parent, 0);
        column.setLayout((Layout)ExampleUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        Control fileUploadArea = this.createFileUploadArea(column);
        fileUploadArea.setLayoutData((Object)ExampleUtil.createHorzFillData());
        Composite fileDialogArea = this.createFileDialogArea(column);
        fileDialogArea.setLayoutData((Object)ExampleUtil.createHorzFillData());
        return column;
    }

    private Control createLogColumn(Composite parent) {
        Composite column = new Composite(parent, 0);
        column.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)column, (String)"Server log", (int)2);
        this.logText = new Text(column, 2314);
        this.logText.setText(INITIAL_TEXT);
        this.logText.setLayoutData((Object)ExampleUtil.createFillData());
        this.createClearButton(column);
        return column;
    }

    private static Control createInfoColumn(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)ExampleUtil.createFillData());
        return label;
    }

    private Control createFileUploadArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)true, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)area, (String)"FileUpload widget", (int)2);
        this.fileUpload = new FileUpload(area, 0);
        this.fileUpload.setText("Select File");
        this.fileUpload.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fileNameLabel = new Label(area, 0);
        this.fileNameLabel.setText("no file selected");
        this.fileNameLabel.setLayoutData((Object)ExampleUtil.createHorzFillData());
        this.fileNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.uploadButton = new Button(area, 8);
        this.uploadButton.setText("Upload");
        this.uploadButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        new Label(area, 0);
        this.fileUpload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = FileUploadExamplePage.this.fileUpload.getFileName();
                FileUploadExamplePage.this.fileNameLabel.setText(fileName == null ? "" : fileName);
            }
        });
        final String url = this.startUploadReceiver();
        this.pushSession = new ServerPushSession();
        this.uploadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileUploadExamplePage.this.pushSession.start();
                FileUploadExamplePage.this.fileUpload.submit(url);
            }
        });
        return area;
    }

    private String startUploadReceiver() {
        DiskFileUploadReceiver receiver = new DiskFileUploadReceiver();
        FileUploadHandler uploadHandler = new FileUploadHandler((FileUploadReceiver)receiver);
        uploadHandler.addUploadListener(new FileUploadListener(){

            public void uploadProgress(FileUploadEvent event) {
            }

            public void uploadFailed(FileUploadEvent event) {
                FileUploadExamplePage.this.addToLog("upload failed: " + event.getException());
            }

            public void uploadFinished(FileUploadEvent event) {
                FileDetails[] fileDetailsArray = event.getFileDetails();
                int n = fileDetailsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FileDetails file = fileDetailsArray[n2];
                    FileUploadExamplePage.this.addToLog("received: " + file.getFileName());
                    ++n2;
                }
            }
        });
        return uploadHandler.getUploadUrl();
    }

    private void addToLog(final String message) {
        if (!this.logText.isDisposed()) {
            this.logText.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String text = FileUploadExamplePage.this.logText.getText();
                    if (FileUploadExamplePage.INITIAL_TEXT.equals(text)) {
                        text = "";
                    }
                    FileUploadExamplePage.this.logText.setText(String.valueOf(text) + message + "\n");
                    FileUploadExamplePage.this.pushSession.stop();
                }
            });
        }
    }

    private Composite createFileDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)true, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)area, (String)"FileDialog", (int)2);
        this.createAddSingleButton(area);
        new Label(area, 0);
        this.createAddMultiButton(area);
        return area;
    }

    private void createAddSingleButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)ExampleUtil.createHorzFillData());
        button.setText("Single File");
        button.setToolTipText("Launches file dialog for single file selection.");
        final Shell parentShell = parent.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileUploadExamplePage.this.openFileDialog(parentShell, false);
            }
        });
    }

    private void createAddMultiButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)ExampleUtil.createHorzFillData());
        button.setText("Multiple Files");
        button.setToolTipText("Launches file dialog for multiple file selection.");
        final Shell parentShell = parent.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileUploadExamplePage.this.openFileDialog(parentShell, true);
            }
        });
    }

    private void createClearButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)ExampleUtil.createHorzFillData());
        button.setText("Clear");
        button.setToolTipText("Clears the results list");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileUploadExamplePage.this.logText.setText(FileUploadExamplePage.INITIAL_TEXT);
            }
        });
    }

    private void openFileDialog(Shell parent, boolean multi) {
        final FileDialog fileDialog = new FileDialog(parent, FileUploadExamplePage.getDialogStyle(multi));
        fileDialog.setText(multi ? "Upload Multiple Files" : "Upload Single File");
        DialogUtil.open((Dialog)fileDialog, (DialogCallback)new DialogCallback(){

            public void dialogClosed(int returnCode) {
                FileUploadExamplePage.this.showUploadResults(fileDialog);
            }
        });
    }

    private void showUploadResults(FileDialog fileDialog) {
        String[] selectedFiles;
        String[] stringArray = selectedFiles = fileDialog.getFileNames();
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.addToLog("received: " + new File(fileName).getName());
            ++n2;
        }
    }

    private static int getDialogStyle(boolean multi) {
        int result = 66800;
        if (multi) {
            result |= 2;
        }
        return result;
    }
}

