/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpOutput
extends ServletOutputStream
implements Runnable {
    private static Logger LOG = Log.getLogger(HttpOutput.class);
    private final HttpChannel<?> _channel;
    private final SharedBlockingCallback _writeblock = new SharedBlockingCallback(){

        protected long getIdleTimeout() {
            return HttpOutput.this._channel.getIdleTimeout();
        }
    };
    private long _written;
    private ByteBuffer _aggregate;
    private int _bufferSize;
    private int _commitSize;
    private WriteListener _writeListener;
    private volatile Throwable _onError;
    private final AtomicReference<OutputState> _state = new AtomicReference<OutputState>(OutputState.OPEN);

    public HttpOutput(HttpChannel<?> channel) {
        this._channel = channel;
        HttpConfiguration config = channel.getHttpConfiguration();
        this._bufferSize = config.getOutputBufferSize();
        this._commitSize = config.getOutputAggregationSize();
        if (this._commitSize > this._bufferSize) {
            LOG.warn("OutputAggregationSize {} exceeds bufferSize {}", new Object[]{this._commitSize, this._bufferSize});
            this._commitSize = this._bufferSize;
        }
    }

    public HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    public boolean isWritten() {
        return this._written > 0L;
    }

    public long getWritten() {
        return this._written;
    }

    public void reset() {
        this._written = 0L;
        this.reopen();
    }

    public void reopen() {
        this._state.set(OutputState.OPEN);
    }

    public boolean isAllContentWritten() {
        return this._channel.getResponse().isAllContentWritten(this._written);
    }

    protected SharedBlockingCallback.Blocker acquireWriteBlockingCallback() throws IOException {
        return this._writeblock.acquire();
    }

    protected void write(ByteBuffer content, boolean complete) throws IOException {
        try (SharedBlockingCallback.Blocker blocker = this._writeblock.acquire();){
            this.write(content, complete, (Callback)blocker);
            blocker.block();
        }
    }

    protected void write(ByteBuffer content, boolean complete, Callback callback) {
        this._channel.write(content, complete, callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block6: while (true) {
            OutputState state = this._state.get();
            switch (state) {
                case CLOSED: {
                    return;
                }
                case UNREADY: {
                    if (!this._state.compareAndSet(state, OutputState.ERROR)) continue block6;
                    this._writeListener.onError(this._onError == null ? new EofException("Async close") : this._onError);
                    continue block6;
                }
            }
            if (this._state.compareAndSet(state, OutputState.CLOSED)) break;
        }
        try {
            this.write(BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER, !this._channel.getResponse().isIncluding());
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            this._channel.abort();
        }
        this.releaseBuffer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void closed() {
        block6: while (true) {
            OutputState state = this._state.get();
            switch (state) {
                case CLOSED: {
                    return;
                }
                case UNREADY: {
                    if (!this._state.compareAndSet(state, OutputState.ERROR)) continue block6;
                    this._writeListener.onError(this._onError == null ? new EofException("Async closed") : this._onError);
                    continue block6;
                }
            }
            if (this._state.compareAndSet(state, OutputState.CLOSED)) break;
        }
        try {
            this._channel.getResponse().closeOutput();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            this._channel.abort();
        }
        this.releaseBuffer();
    }

    private void releaseBuffer() {
        if (this._aggregate != null) {
            this._channel.getConnector().getByteBufferPool().release(this._aggregate);
            this._aggregate = null;
        }
    }

    public boolean isClosed() {
        return this._state.get() == OutputState.CLOSED;
    }

    public void flush() throws IOException {
        block8: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    this.write(BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER, false);
                    return;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(OutputState.READY, OutputState.PENDING)) continue block8;
                    new AsyncFlush().iterate();
                    return;
                }
                case UNREADY: 
                case PENDING: {
                    throw new WritePendingException();
                }
                case ERROR: {
                    throw new EofException(this._onError);
                }
                case CLOSED: {
                    return;
                }
            }
            break;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._written += (long)len;
        boolean complete = this._channel.getResponse().isAllContentWritten(this._written);
        block8: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    break block8;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(OutputState.READY, OutputState.PENDING)) continue block8;
                    if (!complete && len <= this._commitSize) {
                        int filled;
                        if (this._aggregate == null) {
                            this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
                        }
                        if ((filled = BufferUtil.fill((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len)) == len && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                            if (!this._state.compareAndSet(OutputState.PENDING, OutputState.ASYNC)) {
                                throw new IllegalStateException();
                            }
                            return;
                        }
                        off += filled;
                        len -= filled;
                    }
                    new AsyncWrite(b, off, len, complete).iterate();
                    return;
                }
                case UNREADY: 
                case PENDING: {
                    throw new WritePendingException();
                }
                case ERROR: {
                    throw new EofException(this._onError);
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
            }
            break;
        }
        int capacity = this.getBufferSize();
        if (!complete && len <= this._commitSize) {
            int filled;
            if (this._aggregate == null) {
                this._aggregate = this._channel.getByteBufferPool().acquire(capacity, false);
            }
            if ((filled = BufferUtil.fill((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len)) == len && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                return;
            }
            off += filled;
            len -= filled;
        }
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this.write(this._aggregate, complete && len == 0);
            if (len > 0 && !complete && len <= this._commitSize && len <= BufferUtil.space((ByteBuffer)this._aggregate)) {
                BufferUtil.append((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len);
                return;
            }
        }
        if (len > 0) {
            ByteBuffer wrap = ByteBuffer.wrap(b, off, len);
            ByteBuffer view = wrap.duplicate();
            while (len > this.getBufferSize()) {
                int p = view.position();
                int l = p + this.getBufferSize();
                view.limit(p + this.getBufferSize());
                this.write(view, false);
                view.limit(l + Math.min(len -= this.getBufferSize(), this.getBufferSize()));
                view.position(l);
            }
            this.write(view, complete);
        } else if (complete) {
            this.write(BufferUtil.EMPTY_BUFFER, complete);
        }
        if (complete) {
            this.closed();
        }
    }

    public void write(ByteBuffer buffer) throws IOException {
        this._written += (long)buffer.remaining();
        boolean complete = this._channel.getResponse().isAllContentWritten(this._written);
        block8: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    break block8;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(OutputState.READY, OutputState.PENDING)) continue block8;
                    new AsyncWrite(buffer, complete).iterate();
                    return;
                }
                case UNREADY: 
                case PENDING: {
                    throw new WritePendingException();
                }
                case ERROR: {
                    throw new EofException(this._onError);
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
            }
            break;
        }
        int len = BufferUtil.length((ByteBuffer)buffer);
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this.write(this._aggregate, complete && len == 0);
        }
        if (len > 0) {
            this.write(buffer, complete);
        } else if (complete) {
            this.write(BufferUtil.EMPTY_BUFFER, complete);
        }
        if (complete) {
            this.closed();
        }
    }

    public void write(int b) throws IOException {
        ++this._written;
        boolean complete = this._channel.getResponse().isAllContentWritten(this._written);
        block17: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    if (this._aggregate == null) {
                        this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
                    }
                    BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)b));
                    if (!complete && !BufferUtil.isFull((ByteBuffer)this._aggregate)) break block17;
                    try (SharedBlockingCallback.Blocker blocker = this._writeblock.acquire();){
                        this.write(this._aggregate, complete, (Callback)blocker);
                        blocker.block();
                    }
                    if (!complete) break block17;
                    this.closed();
                    break block17;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(OutputState.READY, OutputState.PENDING)) continue block17;
                    if (this._aggregate == null) {
                        this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
                    }
                    BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)b));
                    if (!complete && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                        if (!this._state.compareAndSet(OutputState.PENDING, OutputState.ASYNC)) {
                            throw new IllegalStateException();
                        }
                        return;
                    }
                    new AsyncFlush().iterate();
                    return;
                }
                case UNREADY: 
                case PENDING: {
                    throw new WritePendingException();
                }
                case ERROR: {
                    throw new EofException(this._onError);
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
            }
            break;
        }
    }

    public void print(String s) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        this.write(s.getBytes(this._channel.getResponse().getCharacterEncoding()));
    }

    public void sendContent(ByteBuffer content) throws IOException {
        try (SharedBlockingCallback.Blocker blocker = this._writeblock.acquire();){
            this.write(content, true, (Callback)blocker);
            blocker.block();
        }
    }

    public void sendContent(InputStream in) throws IOException {
        try (SharedBlockingCallback.Blocker blocker = this._writeblock.acquire();){
            new InputStreamWritingCB(in, (Callback)blocker).iterate();
            blocker.block();
        }
    }

    public void sendContent(ReadableByteChannel in) throws IOException {
        try (SharedBlockingCallback.Blocker blocker = this._writeblock.acquire();){
            new ReadableByteChannelWritingCB(in, (Callback)blocker).iterate();
            blocker.block();
        }
    }

    public void sendContent(HttpContent content) throws IOException {
        try (SharedBlockingCallback.Blocker blocker = this._writeblock.acquire();){
            this.sendContent(content, (Callback)blocker);
            blocker.block();
        }
    }

    public void sendContent(ByteBuffer content, final Callback callback) {
        this.write(content, true, new Callback(){

            public void succeeded() {
                HttpOutput.this.closed();
                callback.succeeded();
            }

            public void failed(Throwable x) {
                callback.failed(x);
            }
        });
    }

    public void sendContent(InputStream in, Callback callback) {
        new InputStreamWritingCB(in, callback).iterate();
    }

    public void sendContent(ReadableByteChannel in, Callback callback) {
        new ReadableByteChannelWritingCB(in, callback).iterate();
    }

    public void sendContent(HttpContent httpContent, Callback callback) {
        ByteBuffer buffer;
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            callback.failed((Throwable)new IOException("cannot sendContent() after write()"));
            return;
        }
        if (this._channel.isCommitted()) {
            callback.failed((Throwable)new IOException("committed"));
            return;
        }
        block7: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    if (this._state.compareAndSet(OutputState.OPEN, OutputState.PENDING)) break block7;
                    continue block7;
                }
                case ERROR: {
                    callback.failed((Throwable)new EofException(this._onError));
                    return;
                }
                case CLOSED: {
                    callback.failed((Throwable)new EofException("Closed"));
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            break;
        }
        ByteBuffer byteBuffer = buffer = this._channel.useDirectBuffers() ? httpContent.getDirectBuffer() : null;
        if (buffer == null) {
            buffer = httpContent.getIndirectBuffer();
        }
        if (buffer != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendContent({}=={},{},direct={})", new Object[]{httpContent, BufferUtil.toDetailString((ByteBuffer)buffer), callback, this._channel.useDirectBuffers()});
            }
            this.sendContent(buffer, callback);
            return;
        }
        try {
            ReadableByteChannel rbc = httpContent.getReadableByteChannel();
            if (rbc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendContent({}=={},{},direct={})", new Object[]{httpContent, rbc, callback, this._channel.useDirectBuffers()});
                }
                this.sendContent(rbc, callback);
                return;
            }
            InputStream in = httpContent.getInputStream();
            if (in != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendContent({}=={},{},direct={})", new Object[]{httpContent, in, callback, this._channel.useDirectBuffers()});
                }
                this.sendContent(in, callback);
                return;
            }
        }
        catch (Throwable th) {
            callback.failed(th);
            return;
        }
        callback.failed((Throwable)new IllegalArgumentException("unknown content for " + httpContent));
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
        this._commitSize = size;
    }

    public void resetBuffer() {
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            BufferUtil.clear((ByteBuffer)this._aggregate);
        }
    }

    public void setWriteListener(WriteListener writeListener) {
        if (!this._channel.getState().isAsync()) {
            throw new IllegalStateException("!ASYNC");
        }
        if (!this._state.compareAndSet(OutputState.OPEN, OutputState.READY)) {
            throw new IllegalStateException();
        }
        this._writeListener = writeListener;
        this._channel.getState().onWritePossible();
    }

    public boolean isReady() {
        block9: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    return true;
                }
                case ASYNC: {
                    if (!this._state.compareAndSet(OutputState.ASYNC, OutputState.READY)) continue block9;
                    return true;
                }
                case READY: {
                    return true;
                }
                case PENDING: {
                    if (!this._state.compareAndSet(OutputState.PENDING, OutputState.UNREADY)) continue block9;
                    return false;
                }
                case UNREADY: {
                    return false;
                }
                case ERROR: {
                    return true;
                }
                case CLOSED: {
                    return true;
                }
            }
        }
    }

    @Override
    public void run() {
        block8: while (true) {
            OutputState state = this._state.get();
            if (this._onError != null) {
                switch (state) {
                    case CLOSED: 
                    case ERROR: {
                        this._onError = null;
                        break;
                    }
                    default: {
                        if (!this._state.compareAndSet(state, OutputState.ERROR)) continue block8;
                        Throwable th = this._onError;
                        this._onError = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("onError", th);
                        }
                        this._writeListener.onError(th);
                        this.close();
                        break;
                    }
                }
                break;
            }
            switch (this._state.get()) {
                case CLOSED: 
                case READY: {
                    try {
                        this._writeListener.onWritePossible();
                        break block8;
                    }
                    catch (Throwable e) {
                        this._onError = e;
                        continue block8;
                    }
                }
                default: {
                    this._onError = new IllegalStateException("state=" + (Object)((Object)this._state.get()));
                    continue block8;
                }
            }
            break;
        }
    }

    public String toString() {
        return String.format("%s@%x{%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state.get()});
    }

    static /* synthetic */ AtomicReference access$100(HttpOutput x0) {
        return x0._state;
    }

    private class ReadableByteChannelWritingCB
    extends IteratingNestedCallback {
        private final ReadableByteChannel _in;
        private final ByteBuffer _buffer;
        private boolean _eof;

        public ReadableByteChannelWritingCB(ReadableByteChannel in, Callback callback) {
            super(callback);
            this._in = in;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), HttpOutput.this._channel.useDirectBuffers());
        }

        protected IteratingCallback.Action process() throws Exception {
            if (this._eof) {
                this._in.close();
                HttpOutput.this.closed();
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                return IteratingCallback.Action.SUCCEEDED;
            }
            this._buffer.clear();
            while (this._buffer.hasRemaining() && !this._eof) {
                this._eof = this._in.read(this._buffer) < 0;
            }
            this._buffer.flip();
            HttpOutput.this.write(this._buffer, this._eof, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        public void onCompleteFailure(Throwable x) {
            super.onCompleteFailure(x);
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            try {
                this._in.close();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }
    }

    private class InputStreamWritingCB
    extends IteratingNestedCallback {
        private final InputStream _in;
        private final ByteBuffer _buffer;
        private boolean _eof;

        public InputStreamWritingCB(InputStream in, Callback callback) {
            super(callback);
            this._in = in;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), false);
        }

        protected IteratingCallback.Action process() throws Exception {
            if (this._eof) {
                this._in.close();
                HttpOutput.this.closed();
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                return IteratingCallback.Action.SUCCEEDED;
            }
            int len = 0;
            while (len < this._buffer.capacity() && !this._eof) {
                int r = this._in.read(this._buffer.array(), this._buffer.arrayOffset() + len, this._buffer.capacity() - len);
                if (r < 0) {
                    this._eof = true;
                    continue;
                }
                len += r;
            }
            this._buffer.position(0);
            this._buffer.limit(len);
            HttpOutput.this.write(this._buffer, this._eof, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        public void onCompleteFailure(Throwable x) {
            super.onCompleteFailure(x);
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            try {
                this._in.close();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }
    }

    private class AsyncWrite
    extends AsyncICB {
        private final ByteBuffer _buffer;
        private final ByteBuffer _slice;
        private final boolean _complete;
        private final int _len;
        protected volatile boolean _completed;

        public AsyncWrite(byte[] b, int off, int len, boolean complete) {
            this._buffer = ByteBuffer.wrap(b, off, len);
            this._len = len;
            this._slice = this._len < HttpOutput.this.getBufferSize() ? null : this._buffer.duplicate();
            this._complete = complete;
        }

        public AsyncWrite(ByteBuffer buffer, boolean complete) {
            this._buffer = buffer;
            this._len = buffer.remaining();
            this._slice = this._buffer.isDirect() || this._len < HttpOutput.this.getBufferSize() ? null : this._buffer.duplicate();
            this._complete = complete;
        }

        protected IteratingCallback.Action process() {
            if (BufferUtil.hasContent((ByteBuffer)HttpOutput.this._aggregate)) {
                this._completed = this._len == 0;
                HttpOutput.this.write(HttpOutput.this._aggregate, this._complete && this._completed, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (!this._complete && this._len < BufferUtil.space((ByteBuffer)HttpOutput.this._aggregate) && this._len < HttpOutput.this._commitSize) {
                int position = BufferUtil.flipToFill((ByteBuffer)HttpOutput.this._aggregate);
                BufferUtil.put((ByteBuffer)this._buffer, (ByteBuffer)HttpOutput.this._aggregate);
                BufferUtil.flipToFlush((ByteBuffer)HttpOutput.this._aggregate, (int)position);
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this._buffer.hasRemaining()) {
                if (this._slice == null) {
                    this._completed = true;
                    HttpOutput.this.write(this._buffer, this._complete, (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                int p = this._buffer.position();
                int l = Math.min(HttpOutput.this.getBufferSize(), this._buffer.remaining());
                int pl = p + l;
                this._slice.limit(pl);
                this._buffer.position(pl);
                this._slice.position(p);
                this._completed = !this._buffer.hasRemaining();
                HttpOutput.this.write(this._slice, this._complete && this._completed, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (this._complete && !this._completed) {
                this._completed = true;
                HttpOutput.this.write(BufferUtil.EMPTY_BUFFER, this._complete, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            return IteratingCallback.Action.SUCCEEDED;
        }

        @Override
        protected void onCompleteSuccess() {
            super.onCompleteSuccess();
            if (this._complete) {
                HttpOutput.this.closed();
            }
        }
    }

    private class AsyncFlush
    extends AsyncICB {
        protected volatile boolean _flushed;

        protected IteratingCallback.Action process() {
            if (BufferUtil.hasContent((ByteBuffer)HttpOutput.this._aggregate)) {
                this._flushed = true;
                HttpOutput.this.write(HttpOutput.this._aggregate, false, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (!this._flushed) {
                this._flushed = true;
                HttpOutput.this.write(BufferUtil.EMPTY_BUFFER, false, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            return IteratingCallback.Action.SUCCEEDED;
        }
    }

    private abstract class AsyncICB
    extends IteratingCallback {
        private AsyncICB() {
        }

        /*
         * Unable to fully structure code
         */
        protected void onCompleteSuccess() {
            block5: while (true) {
                last = (OutputState)HttpOutput.access$100(HttpOutput.this).get();
                switch (3.$SwitchMap$org$eclipse$jetty$server$HttpOutput$OutputState[last.ordinal()]) {
                    case 6: {
                        if (HttpOutput.access$100(HttpOutput.this).compareAndSet(OutputState.PENDING, OutputState.ASYNC)) break block5;
                        continue block5;
                    }
                    case 2: {
                        if (HttpOutput.access$100(HttpOutput.this).compareAndSet(OutputState.UNREADY, OutputState.READY)) ** break;
                        continue block5;
                        HttpOutput.access$000(HttpOutput.this).getState().onWritePossible();
                        break block5;
                    }
                    case 1: {
                        break block5;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
        }

        public void onCompleteFailure(Throwable e) {
            HttpOutput.this._onError = e == null ? new IOException() : e;
            HttpOutput.this._channel.getState().onWritePossible();
        }
    }

    static enum OutputState {
        OPEN,
        ASYNC,
        READY,
        PENDING,
        UNREADY,
        ERROR,
        CLOSED;

    }
}

