/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.gridkit;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public class GridOperationHandler
extends ControlOperationHandler<Grid> {
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SCROLL_LEFT = "scrollLeft";
    private static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    private static final String PROP_FOCUS_ITEM = "focusItem";
    private static final String METHOD_RENDER_TOOLTIP_TEXT = "renderToolTipText";

    public GridOperationHandler(Grid grid) {
        super((Control)grid);
    }

    public void handleSet(Grid grid, JsonObject properties) {
        super.handleSet((Control)grid, properties);
        this.handleSetSelection(grid, properties);
        this.handleSetScrollLeft(grid, properties);
        this.handleSetTopItemIndex(grid, properties);
        this.handleSetFocusItem(grid, properties);
    }

    public void handleCall(Grid grid, String method, JsonObject properties) {
        if (METHOD_RENDER_TOOLTIP_TEXT.equals(method)) {
            this.handleCallRenderToolTipText(grid, properties);
        }
    }

    public void handleNotify(Grid grid, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(grid, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(grid, properties);
        } else if ("Expand".equals(eventName)) {
            this.handleNotifyExpand(grid, properties);
        } else if ("Collapse".equals(eventName)) {
            this.handleNotifyCollapse(grid, properties);
        } else if ("SetData".equals(eventName)) {
            this.handleNotifySetData(grid, properties);
        } else {
            super.handleNotify((Control)grid, eventName, properties);
        }
    }

    public void handleSetSelection(Grid grid, JsonObject properties) {
        JsonValue values = properties.get(PROP_SELECTION);
        if (values != null) {
            JsonArray itemIds = values.asArray();
            GridItem[] selectedItems = new GridItem[itemIds.size()];
            boolean validItemFound = false;
            int i = 0;
            while (i < itemIds.size()) {
                selectedItems[i] = GridOperationHandler.getItem(grid, itemIds.get(i).asString());
                if (selectedItems[i] != null) {
                    validItemFound = true;
                }
                ++i;
            }
            if (!validItemFound) {
                selectedItems = new GridItem[]{};
            }
            grid.setSelection(selectedItems);
        }
    }

    public void handleSetScrollLeft(Grid grid, JsonObject properties) {
        JsonValue value = properties.get(PROP_SCROLL_LEFT);
        if (value != null) {
            GridOperationHandler.setScrollBarSelection(grid.getHorizontalBar(), value.asInt());
        }
    }

    public void handleSetTopItemIndex(Grid grid, JsonObject properties) {
        JsonValue value = properties.get(PROP_TOP_ITEM_INDEX);
        if (value != null) {
            GridOperationHandler.getGridAdapter(grid).invalidateTopIndex();
            GridOperationHandler.setScrollBarSelection(grid.getVerticalBar(), value.asInt());
        }
    }

    public void handleSetFocusItem(Grid grid, JsonObject properties) {
        GridItem item;
        JsonValue value = properties.get(PROP_FOCUS_ITEM);
        if (value != null && (item = GridOperationHandler.getItem(grid, value.asString())) != null) {
            grid.setFocusItem(item);
        }
    }

    public void handleCallRenderToolTipText(Grid grid, JsonObject properties) {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter((Widget)grid);
        ICellToolTipProvider provider = adapter.getCellToolTipProvider();
        if (provider != null) {
            GridItem item = GridOperationHandler.getItem(grid, properties.get("item").asString());
            int columnIndex = properties.get("column").asInt();
            if (item != null && (columnIndex == 0 || columnIndex < grid.getColumnCount())) {
                provider.getToolTipText((Item)item, columnIndex);
            }
        }
    }

    public void handleNotifySelection(Grid grid, JsonObject properties) {
        GridItem item = GridOperationHandler.getItem(grid, properties.get("item").asString());
        if (item != null) {
            Event event = GridOperationHandler.createSelectionEvent((int)13, (JsonObject)properties);
            event.item = item;
            event.index = GridOperationHandler.readIndex(properties);
            grid.notifyListeners(13, event);
        }
    }

    public void handleNotifyDefaultSelection(Grid grid, JsonObject properties) {
        GridItem item = GridOperationHandler.getItem(grid, properties.get("item").asString());
        if (item != null) {
            Event event = GridOperationHandler.createSelectionEvent((int)14, (JsonObject)properties);
            event.item = item;
            grid.notifyListeners(14, event);
        }
    }

    public void handleNotifyExpand(Grid grid, JsonObject properties) {
        GridItem item = GridOperationHandler.getItem(grid, properties.get("item").asString());
        if (item != null) {
            Event event = new Event();
            event.item = item;
            grid.notifyListeners(17, event);
        }
    }

    public void handleNotifyCollapse(Grid grid, JsonObject properties) {
        GridItem item = GridOperationHandler.getItem(grid, properties.get("item").asString());
        if (item != null) {
            Event event = new Event();
            event.item = item;
            grid.notifyListeners(18, event);
        }
    }

    public void handleNotifySetData(Grid grid, JsonObject properties) {
    }

    private static GridItem getItem(Grid grid, String itemId) {
        return (GridItem)WidgetUtil.find((Composite)grid, (String)itemId);
    }

    private static void setScrollBarSelection(ScrollBar scrollBar, int selection) {
        if (scrollBar != null) {
            scrollBar.setSelection(selection);
        }
    }

    private static int readIndex(JsonObject properties) {
        JsonValue value = properties.get("index");
        return value == null ? 0 : value.asInt();
    }

    private static IGridAdapter getGridAdapter(Grid grid) {
        return grid.getAdapter(IGridAdapter.class);
    }
}

