/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Widget;

public class WidgetRemoteAdapter
implements RemoteAdapter,
SerializableCompatibility {
    private static final Runnable[] EMPTY = new Runnable[0];
    private final String id;
    private Widget parent;
    private boolean initialized;
    private transient Map<String, Object> preservedValues;
    private transient long preservedListeners;
    private transient Runnable[] renderRunnables;
    private transient Object[] data;
    private transient String variant;

    public WidgetRemoteAdapter(String id) {
        this.id = id;
        this.initialize();
    }

    void initialize() {
        this.preservedValues = new HashMap<String, Object>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setParent(Widget parent) {
        this.parent = parent;
    }

    @Override
    public Widget getParent() {
        return this.parent;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void preserve(String propertyName, Object value) {
        this.preservedValues.put(propertyName, value);
    }

    @Override
    public Object getPreserved(String propertyName) {
        return this.preservedValues.get(propertyName);
    }

    public void preserveListener(int eventType, boolean value) {
        long eventMask = WidgetRemoteAdapter.getEventMask(eventType);
        this.preservedListeners = value ? (this.preservedListeners |= eventMask) : (this.preservedListeners &= eventMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean getPreservedListener(int eventType) {
        return (this.preservedListeners & WidgetRemoteAdapter.getEventMask(eventType)) != 0L;
    }

    public void preserveData(Object[] data) {
        this.data = data;
    }

    public Object[] getPreservedData() {
        return this.data;
    }

    public void preserveVariant(String variant) {
        this.variant = variant;
    }

    public String getPreservedVariant() {
        return this.variant;
    }

    public void clearPreserved() {
        this.preservedValues.clear();
        this.preservedListeners = 0L;
        this.data = null;
        this.variant = null;
    }

    public void addRenderRunnable(Runnable renderRunnable) {
        if (this.renderRunnables == null) {
            this.renderRunnables = new Runnable[]{renderRunnable};
        } else {
            Runnable[] newRunnables = new Runnable[this.renderRunnables.length + 1];
            System.arraycopy(this.renderRunnables, 0, newRunnables, 0, this.renderRunnables.length);
            newRunnables[newRunnables.length - 1] = renderRunnable;
            this.renderRunnables = newRunnables;
        }
    }

    public Runnable[] getRenderRunnables() {
        return this.renderRunnables == null ? EMPTY : this.renderRunnables;
    }

    public void clearRenderRunnables() {
        this.renderRunnables = null;
    }

    @Override
    public void markDisposed(Widget widget) {
        if (this.initialized) {
            DisposedWidgets.add(widget);
        }
    }

    private Object readResolve() {
        this.initialize();
        return this;
    }

    private static long getEventMask(int eventType) {
        if (eventType <= 0 || eventType > 64) {
            throw new IllegalArgumentException("eventType not supported: " + eventType);
        }
        return 1L << eventType - 1;
    }
}

