/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.service;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.rap.rwt.internal.service.ServletLog;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.SettingStore;
import org.eclipse.rap.rwt.service.SettingStoreEvent;
import org.eclipse.rap.rwt.service.SettingStoreListener;

public final class FileSettingStore
implements SettingStore {
    public static final String FILE_SETTING_STORE_DIR = "org.eclipse.rap.rwt.service.FileSettingStore.dir";
    private final File workDir;
    private final Properties props;
    private final Set<SettingStoreListener> listeners;
    private String id;

    public FileSettingStore(File baseDirectory) {
        ParamCheck.notNull(baseDirectory, "baseDirectory");
        FileSettingStore.checkWorkDir(baseDirectory);
        this.workDir = baseDirectory;
        this.props = new Properties();
        this.listeners = new HashSet<SettingStoreListener>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public synchronized String getAttribute(String name) {
        ParamCheck.notNull(name, "name");
        return this.props.getProperty(name);
    }

    @Override
    public synchronized void setAttribute(String name, String value) throws IOException {
        ParamCheck.notNull(name, "name");
        if (value == null) {
            this.removeAttribute(name);
        } else {
            String oldValue = (String)this.props.setProperty(name, value);
            if (!value.equals(oldValue)) {
                this.notifyListeners(name, oldValue, value);
                this.persist();
            }
        }
    }

    @Override
    public synchronized Enumeration<String> getAttributeNames() {
        final Enumeration<Object> keys = this.props.keys();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return keys.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)keys.nextElement();
            }
        };
    }

    @Override
    public synchronized void loadById(String id) throws IOException {
        ParamCheck.notNullOrEmpty(id, "id");
        this.id = id;
        this.notifyForEachAttribute(true);
        this.props.clear();
        BufferedInputStream inputStream = this.getInputStream(id);
        if (inputStream != null) {
            try {
                this.props.load(inputStream);
                this.notifyForEachAttribute(false);
            }
            finally {
                inputStream.close();
            }
        }
    }

    @Override
    public synchronized void removeAttribute(String name) throws IOException {
        String oldValue = (String)this.props.remove(name);
        if (oldValue != null) {
            this.notifyListeners(name, oldValue, null);
            this.persist();
        }
    }

    @Override
    public synchronized void addSettingStoreListener(SettingStoreListener listener) {
        ParamCheck.notNull(listener, "listener");
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeSettingStoreListener(SettingStoreListener listener) {
        ParamCheck.notNull(listener, "listener");
        this.listeners.remove(listener);
    }

    private BufferedInputStream getInputStream(String streamId) {
        BufferedInputStream result = null;
        File file = this.getStoreFile(streamId);
        if (file.exists()) {
            try {
                result = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fnf) {
                FileSettingStore.log("Should not happen", fnf);
            }
        }
        return result;
    }

    private BufferedOutputStream getOutputStream(String streamId) throws FileNotFoundException {
        File file = this.getStoreFile(streamId);
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private File getStoreFile(String fileName) {
        return new File(this.workDir, fileName);
    }

    private static void log(String msg, Throwable throwable) {
        ServletLog.log(msg, throwable);
    }

    private synchronized void notifyForEachAttribute(boolean removed) {
        Enumeration<Object> attributes = this.props.keys();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            String value = this.props.getProperty(attribute);
            if (removed) {
                this.notifyListeners(attribute, value, null);
                continue;
            }
            this.notifyListeners(attribute, null, value);
        }
    }

    private synchronized void notifyListeners(String attribute, String oldValue, String newValue) {
        SettingStoreEvent event = new SettingStoreEvent(this, attribute, oldValue, newValue);
        for (SettingStoreListener listener : this.listeners) {
            String msg;
            try {
                listener.settingChanged(event);
            }
            catch (Exception exc) {
                msg = "Exception when invoking listener " + listener.getClass().getName();
                FileSettingStore.log(msg, exc);
            }
            catch (LinkageError le) {
                msg = "Linkage error when invoking listener " + listener.getClass().getName();
                FileSettingStore.log(msg, le);
            }
        }
    }

    private void persist() throws IOException {
        try (BufferedOutputStream outputStream = this.getOutputStream(this.id);){
            this.props.store(outputStream, FileSettingStore.class.getName());
        }
    }

    private static void checkWorkDir(File workDir) {
        if (!workDir.isDirectory()) {
            throw new IllegalArgumentException("workDir is not a directory: " + workDir);
        }
    }
}

