/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treekit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeOperationHandler
extends ControlOperationHandler<Tree> {
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SCROLL_LEFT = "scrollLeft";
    private static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    private static final String METHOD_RENDER_TOOLTIP_TEXT = "renderToolTipText";

    public TreeOperationHandler(Tree tree) {
        super(tree);
    }

    @Override
    public void handleSet(Tree tree, JsonObject properties) {
        super.handleSet(tree, properties);
        this.handleSetSelection(tree, properties);
        this.handleSetScrollLeft(tree, properties);
        this.handleSetTopItemIndex(tree, properties);
    }

    @Override
    public void handleCall(Tree tree, String method, JsonObject properties) {
        if (METHOD_RENDER_TOOLTIP_TEXT.equals(method)) {
            this.handleCallRenderToolTipText(tree, properties);
        }
    }

    @Override
    public void handleNotify(Tree tree, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(tree, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(tree, properties);
        } else if ("Expand".equals(eventName)) {
            this.handleNotifyExpand(tree, properties);
        } else if ("Collapse".equals(eventName)) {
            this.handleNotifyCollapse(tree, properties);
        } else if ("SetData".equals(eventName)) {
            this.handleNotifySetData(tree, properties);
        } else {
            super.handleNotify(tree, eventName, properties);
        }
    }

    public void handleSetSelection(Tree tree, JsonObject properties) {
        JsonValue values = properties.get(PROP_SELECTION);
        if (values != null) {
            JsonArray itemIds = values.asArray();
            TreeItem[] selectedItems = new TreeItem[itemIds.size()];
            boolean validItemFound = false;
            int i = 0;
            while (i < itemIds.size()) {
                selectedItems[i] = this.getItem(tree, itemIds.get(i).asString());
                if (selectedItems[i] != null) {
                    validItemFound = true;
                }
                ++i;
            }
            if (!validItemFound) {
                selectedItems = new TreeItem[]{};
            }
            tree.setSelection(selectedItems);
        }
    }

    public void handleSetScrollLeft(Tree tree, JsonObject properties) {
        JsonValue value = properties.get(PROP_SCROLL_LEFT);
        if (value != null) {
            int scrollLeft = value.asInt();
            TreeOperationHandler.getTreeAdapter(tree).setScrollLeft(scrollLeft);
            TreeOperationHandler.setScrollBarSelection(tree.getHorizontalBar(), scrollLeft);
        }
    }

    public void handleSetTopItemIndex(Tree tree, JsonObject properties) {
        JsonValue value = properties.get(PROP_TOP_ITEM_INDEX);
        if (value != null) {
            int topItemIndex = value.asInt();
            TreeOperationHandler.getTreeAdapter(tree).setTopItemIndex(topItemIndex);
            int scrollTop = topItemIndex * tree.getItemHeight();
            TreeOperationHandler.setScrollBarSelection(tree.getVerticalBar(), scrollTop);
        }
    }

    public void handleCallRenderToolTipText(Tree tree, JsonObject properties) {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(tree);
        ICellToolTipProvider provider = adapter.getCellToolTipProvider();
        if (provider != null) {
            TreeItem item = this.getItem(tree, properties.get("item").asString());
            int columnIndex = properties.get("column").asInt();
            if (item != null && (columnIndex == 0 || columnIndex < tree.getColumnCount())) {
                provider.getToolTipText(item, columnIndex);
            }
        }
    }

    public void handleNotifySelection(Tree tree, JsonObject properties) {
        TreeItem item = this.getItem(tree, properties.get("item").asString());
        if (item != null) {
            Event event = TreeOperationHandler.createSelectionEvent(13, properties);
            event.item = item;
            tree.notifyListeners(13, event);
        }
    }

    public void handleNotifyDefaultSelection(Tree tree, JsonObject properties) {
        Event event = TreeOperationHandler.createSelectionEvent(14, properties);
        event.item = this.getItem(tree, properties.get("item").asString());
        tree.notifyListeners(14, event);
    }

    public void handleNotifyExpand(Tree tree, JsonObject properties) {
        TreeItem item = this.getItem(tree, properties.get("item").asString());
        if (item != null) {
            Event event = new Event();
            event.item = item;
            tree.notifyListeners(17, event);
        }
    }

    public void handleNotifyCollapse(Tree tree, JsonObject properties) {
        TreeItem item = this.getItem(tree, properties.get("item").asString());
        if (item != null) {
            Event event = new Event();
            event.item = item;
            tree.notifyListeners(18, event);
        }
    }

    public void handleNotifySetData(Tree tree, JsonObject properties) {
    }

    private TreeItem getItem(Tree tree, String itemId) {
        TreeItem item = null;
        String[] idParts = itemId.split("#");
        if (idParts.length == 2) {
            Widget parent = WidgetUtil.find(tree, idParts[0]);
            if (parent != null) {
                int itemIndex = Integer.parseInt(idParts[1]);
                item = WidgetUtil.getId(tree).equals(idParts[0]) ? tree.getItem(itemIndex) : ((TreeItem)parent).getItem(itemIndex);
            }
        } else {
            item = (TreeItem)WidgetUtil.find(tree, itemId);
        }
        return item;
    }

    private static void setScrollBarSelection(ScrollBar scrollBar, int selection) {
        if (scrollBar != null) {
            scrollBar.setSelection(selection);
        }
    }

    @Override
    protected boolean allowMouseEvent(Tree tree, int x, int y) {
        return super.allowMouseEvent(tree, x, y) && y >= tree.getHeaderHeight();
    }

    private static ITreeAdapter getTreeAdapter(Tree tree) {
        return tree.getAdapter(ITreeAdapter.class);
    }
}

