/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.tab;

import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.tab.HelpContextIds;
import org.eclipse.rap.ui.internal.launch.rwt.tab.RWTLaunchTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class RuntimeSettingsSection
extends RWTLaunchTab {
    private Button cbManualPort;
    private Spinner spnPort;

    public String getName() {
        return "Runtime Settings";
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setText("Runtime Settings");
        group.setLayout((Layout)new GridLayout(2, false));
        this.cbManualPort = this.createCheckButton((Composite)group, "Manual port configuration");
        this.cbManualPort.addSelectionListener((SelectionListener)new ManualPortSelectionListener());
        this.spnPort = new Spinner((Composite)group, 2048);
        this.spnPort.setLayoutData((Object)new GridData(60, -1));
        this.spnPort.setMinimum(0);
        this.spnPort.setMaximum(65535);
        this.spnPort.addModifyListener((ModifyListener)new TextModifyListener());
        this.updateEnablement();
        this.setControl((Control)group);
        HelpContextIds.assign(this.getControl(), HelpContextIds.MAIN_TAB);
    }

    public void initializeFrom(RWTLaunchConfig launchConfig) {
        this.cbManualPort.setSelection(launchConfig.getUseManualPort());
        this.spnPort.setSelection(launchConfig.getPort());
        this.updateEnablement();
    }

    public void performApply(RWTLaunchConfig launchConfig) {
        launchConfig.setUseManualPort(this.cbManualPort.getSelection());
        launchConfig.setPort(this.spnPort.getSelection());
    }

    private void updateEnablement() {
        this.spnPort.setEnabled(this.cbManualPort.getSelection());
    }

    private class ManualPortSelectionListener
    extends SelectionAdapter {
        private ManualPortSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            RuntimeSettingsSection.this.updateEnablement();
            RuntimeSettingsSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            RuntimeSettingsSection.this.updateLaunchConfigurationDialog();
        }
    }
}

