/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import java.io.ByteArrayInputStream;
import org.eclipse.rwt.internal.resources.ContentBuffer;
import org.eclipse.rwt.resources.IResourceManager;

public class JSLibraryConcatenator {
    private final IResourceManager resourceManager;
    private ContentBuffer jsBuffer;
    private String location;

    public JSLibraryConcatenator(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void startJSConcatenation() {
        this.jsBuffer = new ContentBuffer();
    }

    public void appendJSLibrary(byte[] content) {
        if (this.jsBuffer != null) {
            this.jsBuffer.append(content);
        }
    }

    public String getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Class<JSLibraryConcatenator> clazz = JSLibraryConcatenator.class;
        synchronized (JSLibraryConcatenator.class) {
            byte[] content;
            if (this.location == null && (content = this.readContent()).length > 0) {
                this.location = this.register(content, "resources.js");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void deactivate() {
        this.resourceManager.unregister("resources.js");
        this.jsBuffer = null;
        this.location = null;
    }

    byte[] readContent() {
        byte[] content;
        if (this.jsBuffer != null) {
            content = this.jsBuffer.getContent();
            this.jsBuffer = null;
        } else {
            content = new byte[]{};
        }
        return content;
    }

    private String register(byte[] content, String name) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        this.resourceManager.register(name, inputStream, "UTF-8", IResourceManager.RegisterOptions.VERSION);
        return this.resourceManager.getLocation(name);
    }
}

