/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.rap.ui.internal.application.EntryPointApplicationWrapper;
import org.eclipse.rap.ui.internal.branding.BrandingExtension;
import org.eclipse.rap.ui.internal.preferences.WorkbenchFileSettingStoreFactory;
import org.eclipse.rap.ui.internal.servlet.EntryPointParameters;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.application.Application;
import org.eclipse.rwt.application.ApplicationConfiguration;
import org.eclipse.rwt.internal.application.ApplicationImpl;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.lifecycle.IEntryPointFactory;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.rwt.resources.ResourceLoader;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkbenchApplicationConfigurator
implements ApplicationConfiguration {
    private static final String ID_ADAPTER_FACTORY = "org.eclipse.rap.ui.adapterfactory";
    private static final String ID_ENTRY_POINT = "org.eclipse.rap.ui.entrypoint";
    private static final String ID_THEMES = "org.eclipse.rap.ui.themes";
    private static final String ELEMENT_THEME = "theme";
    private static final String ELEMENT_THEME_CONTRIBUTION = "themeContribution";
    private static final String ID_THEMEABLE_WIDGETS = "org.eclipse.rap.ui.themeableWidgets";
    private static final String ID_PHASE_LISTENER = "org.eclipse.rap.ui.phaselistener";
    private static final String ID_SERVICE_HANDLER = "org.eclipse.rap.ui.serviceHandler";
    private static final String ID_RESOURCES = "org.eclipse.rap.ui.resources";
    private static final String ID_SETTING_STORES = "org.eclipse.rap.ui.settingstores";
    private static final String RUN = "run";
    private static final String PI_RUNTIME = "org.eclipse.core.runtime";
    private static final String PT_APPLICATIONS = "applications";
    private static final String PT_APP_VISIBLE = "visible";
    private final ServiceReference<HttpService> httpServiceReference;

    public WorkbenchApplicationConfigurator(ServiceReference<HttpService> httpServiceReference) {
        this.httpServiceReference = httpServiceReference;
    }

    public void configure(Application application) {
        application.setOperationMode(Application.OperationMode.SWT_COMPATIBILITY);
        this.registerPhaseListener(application);
        this.registerSettingStoreFactory(application);
        this.registerWorkbenchEntryPoints((ApplicationImpl)application);
        this.registerApplicationEntryPoints((ApplicationImpl)application);
        this.registerThemeableWidgets(application);
        this.registerThemes(application);
        this.registerThemeContributions(application);
        this.registerAdapterFactories((ApplicationImpl)application);
        WorkbenchApplicationConfigurator.registerResources(application);
        this.registerServiceHandlers(application);
        this.registerBrandings(application);
    }

    private void registerPhaseListener(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_PHASE_LISTENER);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            try {
                Object instance = elements[i].createExecutableExtension("class");
                PhaseListener listener = (PhaseListener)instance;
                application.addPhaseListener(listener);
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }

    private void registerSettingStoreFactory(Application application) {
        String settingStoreFactoryParam = "org.eclipse.rwt.settingStoreFactory";
        String factoryId = WorkbenchApplicationConfigurator.getOSGiProperty(settingStoreFactoryParam);
        ISettingStoreFactory result = null;
        if (factoryId != null) {
            result = this.loadSettingStoreFactory(factoryId);
        }
        if (result == null) {
            result = new WorkbenchFileSettingStoreFactory();
        }
        application.setSettingStoreFactory(result);
    }

    private ISettingStoreFactory loadSettingStoreFactory(String factoryId) {
        ISettingStoreFactory result = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_SETTING_STORES);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute("id");
            if (factoryId.equals(id)) {
                result = this.loadSettingStoreFactory(elements[i]);
            }
            ++i;
        }
        if (result == null) {
            String msg = "Unable to find setting store factory with id '" + factoryId + "'.";
            WorkbenchPlugin.log(msg);
        }
        return result;
    }

    private ISettingStoreFactory loadSettingStoreFactory(IConfigurationElement element) {
        ISettingStoreFactory result = null;
        try {
            result = (ISettingStoreFactory)element.createExecutableExtension("class");
        }
        catch (CoreException cex) {
            WorkbenchPlugin.log(cex.getStatus());
        }
        return result;
    }

    private static String getOSGiProperty(String name) {
        Bundle systemBundle = Platform.getBundle((String)"system.bundle");
        return systemBundle.getBundleContext().getProperty(name);
    }

    private void registerAdapterFactories(ApplicationImpl application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_ADAPTER_FACTORY);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String contributorName = elements[i].getContributor().getName();
            String factoryName = elements[i].getAttribute("factoryClass");
            String adaptableName = elements[i].getAttribute("adaptableClass");
            try {
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class factoryClass = bundle.loadClass(factoryName);
                Class adaptableClass = bundle.loadClass(adaptableName);
                AdapterFactory adapterFactory = (AdapterFactory)ClassUtil.newInstance((Class)factoryClass);
                application.addAdapterFactory(adaptableClass, adapterFactory);
            }
            catch (Throwable thr) {
                String text = "Could not register adapter factory ''{0}''  for the adapter type ''{1}''.";
                Object[] param = new Object[]{factoryName, adaptableName};
                WorkbenchApplicationConfigurator.logProblem(text, param, thr, contributorName);
            }
            ++i;
        }
    }

    private void registerWorkbenchEntryPoints(ApplicationImpl application) {
        IConfigurationElement[] iConfigurationElementArray = WorkbenchApplicationConfigurator.getEntryPointExtensions();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String contributorName = element.getContributor().getName();
            String className = element.getAttribute("class");
            String parameter = element.getAttribute("parameter");
            String path = element.getAttribute("path");
            String id = element.getAttribute("id");
            try {
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class entryPointClass = bundle.loadClass(className);
                if (parameter != null) {
                    application.addEntryPointByParameter(parameter, entryPointClass);
                    EntryPointParameters.register(id, parameter);
                }
                if (path != null) {
                    application.addEntryPoint(path, entryPointClass, null);
                }
            }
            catch (Throwable thr) {
                String text = "Could not register entry point ''{0}'' with id ''{1}''.";
                Object[] param = new Object[]{className, id};
                WorkbenchApplicationConfigurator.logProblem(text, param, thr, contributorName);
            }
            ++n2;
        }
    }

    private void registerApplicationEntryPoints(ApplicationImpl application) {
        IExtension[] iExtensionArray = WorkbenchApplicationConfigurator.getApplicationExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement configElement = extension.getConfigurationElements()[0];
            String contributorName = configElement.getContributor().getName();
            IConfigurationElement[] runElement = configElement.getChildren(RUN);
            String className = runElement[0].getAttribute("class");
            String applicationId = extension.getUniqueIdentifier();
            String applicationParameter = extension.getUniqueIdentifier();
            String isVisible = configElement.getAttribute(PT_APP_VISIBLE);
            try {
                if (isVisible == null || Boolean.valueOf(isVisible).booleanValue()) {
                    Bundle bundle = Platform.getBundle((String)contributorName);
                    Class applicationClass = bundle.loadClass(className);
                    IEntryPointFactory factory = WorkbenchApplicationConfigurator.createApplicationEntryPointFactory(applicationClass);
                    application.addEntryPointByParameter(applicationParameter, factory);
                    EntryPointParameters.register(applicationId, applicationParameter);
                }
            }
            catch (ClassNotFoundException exception) {
                String text = "Could not register application ''{0}'' with request startup parameter ''{1}''.";
                Object[] params = new Object[]{className, applicationParameter};
                WorkbenchApplicationConfigurator.logProblem(text, params, exception, contributorName);
            }
            ++n2;
        }
    }

    private static IEntryPointFactory createApplicationEntryPointFactory(final Class<? extends IApplication> applicationClass) {
        return new IEntryPointFactory(){

            public IEntryPoint create() {
                return new EntryPointApplicationWrapper(applicationClass);
            }
        };
    }

    private void registerThemeableWidgets(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMEABLE_WIDGETS);
        IConfigurationElement[] widgetExts = ep.getConfigurationElements();
        int i = 0;
        while (i < widgetExts.length) {
            String contributorName = widgetExts[i].getContributor().getName();
            String widgetClass = widgetExts[i].getAttribute("class");
            try {
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class widget = bundle.loadClass(widgetClass);
                application.addThemableWidget(widget);
            }
            catch (Throwable thr) {
                String text = "Could not register themeable widget ''{0}''.";
                Object[] param = new Object[]{widgetClass};
                WorkbenchApplicationConfigurator.logProblem(text, param, thr, contributorName);
            }
            ++i;
        }
    }

    private void registerThemes(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (ELEMENT_THEME.equals(elements[i].getName())) {
                String contributorName = elements[i].getContributor().getName();
                String themeId = elements[i].getAttribute("id");
                String themeFile = elements[i].getAttribute("file");
                try {
                    Bundle bundle = Platform.getBundle((String)contributorName);
                    ResourceLoader resourceLoader = WorkbenchApplicationConfigurator.createThemeResourceLoader(bundle);
                    application.addStyleSheet(themeId, themeFile, resourceLoader);
                }
                catch (Exception e) {
                    String text = "Could not register custom theme ''{0}'' from file ''{1}''.";
                    Object[] param = new Object[]{themeId, themeFile};
                    WorkbenchApplicationConfigurator.logProblem(text, param, e, contributorName);
                }
            }
            ++i;
        }
    }

    private void registerThemeContributions(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (ELEMENT_THEME_CONTRIBUTION.equals(elements[i].getName())) {
                String contributorName = elements[i].getContributor().getName();
                String themeId = elements[i].getAttribute("themeId");
                String themeFile = elements[i].getAttribute("file");
                try {
                    Bundle bundle = Platform.getBundle((String)contributorName);
                    ResourceLoader loader = WorkbenchApplicationConfigurator.createThemeResourceLoader(bundle);
                    application.addStyleSheet(themeId, themeFile, loader);
                }
                catch (Exception e) {
                    String text = "Could not register contribution for theme ''{0}'' from file ''{1}''.";
                    Object[] param = new Object[]{themeId, themeFile};
                    WorkbenchApplicationConfigurator.logProblem(text, param, e, contributorName);
                }
            }
            ++i;
        }
    }

    private static ResourceLoader createThemeResourceLoader(final Bundle bundle) {
        ResourceLoader result = new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                InputStream result = null;
                Path path = new Path(resourceName);
                URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                if (url != null) {
                    result = url.openStream();
                }
                return result;
            }
        };
        return result;
    }

    private static void registerResources(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_RESOURCES);
        IConfigurationElement[] elements = point.getConfigurationElements();
        DependentResource[] resources = WorkbenchApplicationConfigurator.loadResources(elements);
        resources = WorkbenchApplicationConfigurator.sortResources(resources);
        WorkbenchApplicationConfigurator.registerResources(resources, application);
    }

    private static DependentResource[] loadResources(IConfigurationElement[] elements) {
        DependentResource[] result = new DependentResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            try {
                IResource resource = (IResource)elements[i].createExecutableExtension("class");
                String resourceId = elements[i].getAttribute("id");
                IConfigurationElement[] dependsOn = elements[i].getChildren("dependsOn");
                ArrayList<String> resourceDependencies = new ArrayList<String>();
                int j = 0;
                while (j < dependsOn.length) {
                    String dependency = dependsOn[j].getAttribute("resourceId");
                    resourceDependencies.add(dependency);
                    ++j;
                }
                result[i] = new DependentResource(resource, resourceId, resourceDependencies);
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
        return result;
    }

    private static DependentResource[] sortResources(DependentResource[] resources) {
        DependentResource[] result = new DependentResource[resources.length];
        ArrayList<String> sortedResourceIds = new ArrayList<String>();
        ArrayList<DependentResource> deferredResources = new ArrayList<DependentResource>();
        int index = 0;
        int i = 0;
        while (i < resources.length) {
            DependentResource resource = resources[i];
            if (resource != null) {
                resource.dependencies.removeAll(sortedResourceIds);
                boolean checkDeferredResources = false;
                if (resource.dependencies.isEmpty()) {
                    result[index++] = resource;
                    sortedResourceIds.add(resource.id);
                    checkDeferredResources = true;
                } else {
                    deferredResources.add(resource);
                }
                while (checkDeferredResources) {
                    checkDeferredResources = false;
                    Iterator iterator = deferredResources.iterator();
                    while (iterator.hasNext()) {
                        DependentResource deferredResource = (DependentResource)iterator.next();
                        deferredResource.dependencies.removeAll(sortedResourceIds);
                        if (!deferredResource.dependencies.isEmpty()) continue;
                        result[index++] = deferredResource;
                        sortedResourceIds.add(deferredResource.id);
                        iterator.remove();
                        checkDeferredResources = true;
                    }
                }
            }
            ++i;
        }
        if (deferredResources.size() != 0) {
            String pluginId = WorkbenchPlugin.getDefault().getBundle().getSymbolicName();
            String message = "Dependencies could not be resolved for " + deferredResources;
            WorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, pluginId, message));
        }
        return result;
    }

    private static void registerResources(DependentResource[] resources, Application application) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null) {
                application.addResource(resources[i].resource);
            }
            ++i;
        }
    }

    private void registerServiceHandlers(Application application) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_SERVICE_HANDLER);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            try {
                String id = elements[i].getAttribute("id");
                if (id != null) {
                    Object extObject = elements[i].createExecutableExtension("class");
                    IServiceHandler handler = (IServiceHandler)extObject;
                    application.addServiceHandler(id, handler);
                }
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }

    private void registerBrandings(Application application) {
        try {
            new BrandingExtension(application, this.httpServiceReference).read();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to read branding extension", ioe);
        }
    }

    private static IConfigurationElement[] getEntryPointExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ID_ENTRY_POINT);
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        return elements;
    }

    private static IExtension[] getApplicationExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        String extensionPointId = "org.eclipse.core.runtime.applications";
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        return extensionPoint.getExtensions();
    }

    private static void logProblem(String text, Object[] textParams, Throwable problem, String bundleId) {
        String msg = MessageFormat.format(text, textParams);
        Status status = new Status(4, bundleId, 0, msg, problem);
        WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DependentResource {
        public final IResource resource;
        public final String id;
        public final List<String> dependencies;

        public DependentResource(IResource resource, String id, List<String> dependencies) {
            this.resource = resource;
            this.id = id;
            this.dependencies = dependencies;
        }

        public String toString() {
            return this.id != null ? this.id : this.resource.getClass().getName();
        }
    }
}

