/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterException;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.ILifeCycleAdapter;
import org.eclipse.rwt.lifecycle.IWidgetLifeCycleAdapter;
import org.eclipse.swt.internal.widgets.displaykit.DisplayLCA;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public final class LifeCycleAdapterFactory {
    private final Object displayAdapterLock = new Object();
    private final Object widgetAdaptersLock = new Object();
    private IDisplayLifeCycleAdapter displayAdapter;
    private final Map<Class, ILifeCycleAdapter> widgetAdapters = new HashMap<Class, ILifeCycleAdapter>();

    public Object getAdapter(Object adaptable) {
        ILifeCycleAdapter result = null;
        if (LifeCycleAdapterFactory.isDisplayLCA(adaptable)) {
            result = this.getDisplayLCA();
        } else if (LifeCycleAdapterFactory.isWidgetLCA(adaptable)) {
            result = this.getWidgetLCA(adaptable.getClass());
        }
        return result;
    }

    private static boolean isDisplayLCA(Object adaptable) {
        return adaptable instanceof Display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILifeCycleAdapter getDisplayLCA() {
        Object object = this.displayAdapterLock;
        synchronized (object) {
            if (this.displayAdapter == null) {
                this.displayAdapter = new DisplayLCA();
            }
            return this.displayAdapter;
        }
    }

    private static boolean isWidgetLCA(Object adaptable) {
        return adaptable instanceof Widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILifeCycleAdapter getWidgetLCA(Class clazz) {
        ILifeCycleAdapter result;
        Object object = this.widgetAdaptersLock;
        synchronized (object) {
            result = this.widgetAdapters.get(clazz);
            if (result == null) {
                IWidgetLifeCycleAdapter adapter = null;
                Class superClass = clazz;
                while (!Object.class.equals((Object)superClass) && adapter == null) {
                    adapter = LifeCycleAdapterFactory.loadWidgetLCA(superClass);
                    if (adapter != null) continue;
                    superClass = superClass.getSuperclass();
                }
                this.widgetAdapters.put(clazz, adapter);
                result = adapter;
            }
        }
        if (result == null) {
            String msg = "Failed to obtain life cycle adapter for: " + clazz.getName();
            throw new LifeCycleAdapterException(msg);
        }
        return result;
    }

    private static IWidgetLifeCycleAdapter loadWidgetLCA(Class clazz) {
        IWidgetLifeCycleAdapter result = null;
        String className = LifeCycleAdapterUtil.getSimpleClassName(clazz);
        String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(clazz);
        int i = 0;
        while (result == null && i < variants.length) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(variants[i]);
            buffer.append(".");
            buffer.append(className);
            buffer.append("LCA");
            String classToLoad = buffer.toString();
            ClassLoader loader = clazz.getClassLoader();
            try {
                result = (IWidgetLifeCycleAdapter)ClassUtil.newInstance(loader, classToLoad);
            }
            catch (ClassInstantiationException classInstantiationException) {}
            ++i;
        }
        return result;
    }
}

