/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ControlDecoratorTab
extends ExampleTab {
    private static final String PROP_SELECTION_LISTENER = "selectionListener";
    private boolean showOnlyOnFocus;
    private boolean showHover = true;
    private final ControlDecoration[] decorations = new ControlDecoration[2];

    public ControlDecoratorTab(CTabFolder topFolder) {
        super(topFolder, "ControlDecorator");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("TOP", 128);
        this.createStyleButton("BOTTOM", 1024);
        this.createStyleButton("LEFT", 16384);
        this.createStyleButton("RIGHT", 131072);
        this.createVisibilityButton();
        this.createChangeDescriptionButton(parent);
        this.createShowOnlyOnFocus(parent);
        this.createShowHover(parent);
        this.createPropertyCheckbox("Add Selection Listener", PROP_SELECTION_LISTENER);
    }

    private void createChangeDescriptionButton(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(group, 0);
        label.setText("Description text: ");
        final Text descriptionText = new Text(group, 2052);
        GridData data = new GridData();
        data.widthHint = 100;
        descriptionText.setLayoutData((Object)data);
        descriptionText.setText("something");
        Button button = new Button(group, 8);
        button.setText("Set");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = 0;
                while (i < ControlDecoratorTab.this.decorations.length) {
                    ControlDecoration decoration = ControlDecoratorTab.this.decorations[i];
                    decoration.setDescriptionText(descriptionText.getText());
                    ++i;
                }
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createControlDecorations(parent);
    }

    private void createControlDecorations(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.horizontalSpacing = 10;
        groupLayout.marginRight = 10;
        group.setLayout((Layout)groupLayout);
        group.setText("ControlDecoration");
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ControlDecoratorTab.this.log("widgetSelected: " + event.toString());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ControlDecoratorTab.this.log("widgetDefaultSelected: " + event.toString());
            }
        };
        this.decorations[0] = this.createStaticExample((Composite)group);
        this.decorations[1] = this.createDynamicExample((Composite)group);
        if (this.hasCreateProperty(PROP_SELECTION_LISTENER)) {
            this.decorations[0].addSelectionListener(listener);
            this.decorations[1].addSelectionListener(listener);
        }
        this.decorations[0].setShowHover(this.showHover);
        this.decorations[1].setShowHover(this.showHover);
        this.decorations[0].setShowOnlyOnFocus(this.showOnlyOnFocus);
        this.decorations[1].setShowOnlyOnFocus(this.showOnlyOnFocus);
    }

    private ControlDecoration createDynamicExample(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Dynamic decoration: ");
        this.registerControl((Control)label);
        final Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.widthHint = 100;
        text.setLayoutData((Object)data);
        text.setText("remove me");
        this.registerControl((Control)text);
        final ControlDecoration dynDecoration = new ControlDecoration((Control)text, this.getStyle());
        Image icon = this.getDecorationImage("DEC_ERROR");
        dynDecoration.setImage(icon);
        dynDecoration.setDescriptionText("Please enter something");
        dynDecoration.setMarginWidth(3);
        dynDecoration.hide();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (text.getText().length() > 0) {
                    dynDecoration.hide();
                } else {
                    dynDecoration.show();
                }
            }
        });
        return dynDecoration;
    }

    private ControlDecoration createStaticExample(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Static decoration: ");
        this.registerControl((Control)label);
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.widthHint = 100;
        text.setLayoutData((Object)data);
        text.setText("some text");
        this.registerControl((Control)text);
        ControlDecoration staticDecoration = new ControlDecoration((Control)text, this.getStyle());
        Image icon = this.getDecorationImage("DEC_INFORMATION");
        staticDecoration.setImage(icon);
        staticDecoration.setDescriptionText("More information");
        staticDecoration.setMarginWidth(3);
        staticDecoration.show();
        return staticDecoration;
    }

    private Image getDecorationImage(String image) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        return registry.getFieldDecoration(image).getImage();
    }

    private void createShowOnlyOnFocus(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Show only on focus");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ControlDecoratorTab.this.showOnlyOnFocus = button.getSelection();
                ControlDecoratorTab.this.decorations[0].setShowOnlyOnFocus(ControlDecoratorTab.this.showOnlyOnFocus);
                ControlDecoratorTab.this.decorations[1].setShowOnlyOnFocus(ControlDecoratorTab.this.showOnlyOnFocus);
            }
        });
    }

    private void createShowHover(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Show hover");
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ControlDecoratorTab.this.showHover = button.getSelection();
                ControlDecoratorTab.this.decorations[0].setShowHover(ControlDecoratorTab.this.showHover);
                ControlDecoratorTab.this.decorations[1].setShowHover(ControlDecoratorTab.this.showHover);
            }
        });
    }
}

