/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.graphics.InternalImage;

final class ImageDataCache {
    private static final int MAX_DATA_SIZE = 1024;
    private final Map cache;
    private final Object cacheLock = new Object();

    public ImageDataCache() {
        this.cache = new HashMap(25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData(InternalImage internalImage) {
        ImageData cached;
        if (internalImage == null) {
            throw new NullPointerException("internalImage");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            cached = (ImageData)this.cache.get(internalImage);
        }
        return cached != null ? (ImageData)cached.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putImageData(InternalImage internalImage, ImageData imageData) {
        if (internalImage == null) {
            throw new NullPointerException("internalImage");
        }
        if (imageData == null) {
            throw new NullPointerException("imageData");
        }
        if (imageData.data.length <= 1024) {
            Object object = this.cacheLock;
            synchronized (object) {
                this.cache.put(internalImage, imageData.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cache.clear();
        }
    }
}

