/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.internal.jpa.deployment.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileArchive
implements Archive {
    private JarFile jarFile;
    private URL rootURL;
    private Logger logger;

    public JarFileArchive(JarFile jarFile) throws MalformedURLException {
        this(jarFile, Logger.global);
    }

    public JarFileArchive(JarFile jarFile, Logger logger) throws MalformedURLException {
        logger.entering("JarFileArchive", "JarFileArchive", new Object[]{jarFile});
        this.logger = logger;
        this.jarFile = jarFile;
        this.rootURL = new File(jarFile.getName()).toURI().toURL();
        logger.logp(Level.FINER, "JarFileArchive", "JarFileArchive", "rootURL = {0}", this.rootURL);
    }

    @Override
    public Iterator<String> getEntries() {
        Enumeration<JarEntry> jarEntries = this.jarFile.entries();
        ArrayList<String> result = new ArrayList<String>();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory()) continue;
            result.add(jarEntry.getName());
        }
        return result.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        InputStream is = null;
        ZipEntry entry = this.jarFile.getEntry(entryPath);
        if (entry != null) {
            is = this.jarFile.getInputStream(entry);
        }
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        return this.jarFile.getEntry(entryPath) != null ? new URL("jar:" + this.rootURL + "!/" + entryPath) : null;
    }

    @Override
    public URL getRootURL() {
        return this.rootURL;
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

