/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBHelperContext;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBListWrapper;

public class JAXBValueStore
implements ValueStore {
    private JAXBHelperContext jaxbHelperContext;
    private Object entity;
    private XMLDescriptor descriptor;
    private SDODataObject dataObject;
    private Map<Property, ListWrapper> listWrappers;

    public JAXBValueStore(JAXBHelperContext aJAXBHelperContext, SDOType sdoType) {
        this.jaxbHelperContext = aJAXBHelperContext;
        QName xsdQName = sdoType.getXsdType();
        if (null == xsdQName) {
            xsdQName = sdoType.getQName();
        }
        this.listWrappers = new WeakHashMap<Property, ListWrapper>();
        XPathFragment xPathFragment = new XPathFragment(xsdQName.getLocalPart());
        xPathFragment.setNamespaceURI(xsdQName.getNamespaceURI());
        JAXBContext jaxbContext = (JAXBContext)this.jaxbHelperContext.getJAXBContext();
        this.descriptor = jaxbContext.getXMLContext().getDescriptorByGlobalType(xPathFragment);
        if (null == this.descriptor) {
            this.descriptor = jaxbContext.getXMLContext().getDescriptor(xsdQName);
            if (null == this.descriptor) {
                throw SDOException.sdoJaxbNoDescriptorForType(sdoType.getQName(), xsdQName);
            }
        }
        this.entity = this.descriptor.getInstantiationPolicy().buildNewInstance();
    }

    public JAXBValueStore(JAXBHelperContext aJAXBHelperContext, Object anEntity) {
        this.jaxbHelperContext = aJAXBHelperContext;
        this.listWrappers = new WeakHashMap<Property, ListWrapper>();
        JAXBContext jaxbContext = (JAXBContext)this.jaxbHelperContext.getJAXBContext();
        this.descriptor = (XMLDescriptor)jaxbContext.getXMLContext().getSession(anEntity).getDescriptor(anEntity);
        this.entity = anEntity;
    }

    SDODataObject getDataObject() {
        return this.dataObject;
    }

    Object getEntity() {
        return this.entity;
    }

    XMLDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    JAXBHelperContext getJAXBHelperContext() {
        return this.jaxbHelperContext;
    }

    public void initialize(DataObject aDataObject) {
        this.dataObject = (SDODataObject)aDataObject;
    }

    public Object getDeclaredProperty(int propertyIndex) {
        SDOProperty declaredProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(propertyIndex);
        DatabaseMapping mapping = this.getJAXBMappingForProperty(declaredProperty);
        Object value = mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
        if (null == value || declaredProperty.getType().isDataType()) {
            if (declaredProperty.isMany()) {
                return new JAXBListWrapper(this, declaredProperty);
            }
            return value;
        }
        if (declaredProperty.isMany()) {
            ListWrapper listWrapper = this.listWrappers.get(declaredProperty);
            if (null != listWrapper) {
                return listWrapper;
            }
            listWrapper = new JAXBListWrapper(this, declaredProperty);
            this.listWrappers.put(declaredProperty, listWrapper);
            return listWrapper;
        }
        if (declaredProperty.isContainment()) {
            return this.jaxbHelperContext.wrap(value, (Property)declaredProperty, (DataObject)this.dataObject);
        }
        return this.jaxbHelperContext.wrap(value);
    }

    public void setDeclaredProperty(int propertyIndex, Object value) {
        SDOProperty declaredProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(propertyIndex);
        DatabaseMapping mapping = this.getJAXBMappingForProperty(declaredProperty);
        Object newValue = value;
        Object oldValue = mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
        if (declaredProperty.getType().isDataType()) {
            if (!declaredProperty.isMany()) {
                AbstractSession session = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
                XMLDirectMapping directMapping = (XMLDirectMapping)mapping;
                if (directMapping.hasConverter()) {
                    newValue = directMapping.getConverter().convertDataValueToObjectValue(newValue, session);
                } else {
                    DatabaseField field = mapping.getField();
                    newValue = session.getDatasourcePlatform().getConversionManager().convertObject(newValue, this.descriptor.getObjectBuilder().getFieldClassification(field));
                }
            }
            mapping.setAttributeValueInObject(this.entity, newValue);
        } else if (declaredProperty.isMany()) {
            ListWrapper listWrapper = (ListWrapper)this.getDeclaredProperty(propertyIndex);
            listWrapper.setCurrentElements((List)newValue);
        } else {
            XMLCompositeObjectMapping compositeMapping;
            if (mapping.isAbstractCompositeObjectMapping()) {
                compositeMapping = (XMLCompositeObjectMapping)mapping;
                if (oldValue != null && compositeMapping.getContainerAccessor() != null) {
                    compositeMapping.getContainerAccessor().setAttributeValueInObject(oldValue, null);
                }
            }
            newValue = this.jaxbHelperContext.unwrap((DataObject)value);
            mapping.getAttributeAccessor().setAttributeValueInObject(this.entity, newValue);
            if (mapping.isAbstractCompositeObjectMapping()) {
                compositeMapping = (XMLCompositeObjectMapping)mapping;
                if (value != null && compositeMapping.getContainerAccessor() != null) {
                    compositeMapping.getContainerAccessor().setAttributeValueInObject(newValue, this.entity);
                }
            }
        }
    }

    public boolean isSetDeclaredProperty(int propertyIndex) {
        SDOProperty declaredProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(propertyIndex);
        DatabaseMapping mapping = this.getJAXBMappingForProperty(declaredProperty);
        if (declaredProperty.isMany()) {
            Collection collection = (Collection)mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
            if (null == collection) {
                return false;
            }
            return !collection.isEmpty();
        }
        return null != mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
    }

    public void unsetDeclaredProperty(int propertyIndex) {
        SDOProperty declaredProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(propertyIndex);
        DatabaseMapping mapping = this.getJAXBMappingForProperty(declaredProperty);
        if (declaredProperty.isMany()) {
            Object oldContainer;
            XMLCompositeCollectionMapping compositeMapping;
            ContainerMapping containerMapping = (ContainerMapping)((Object)mapping);
            ContainerPolicy containerPolicy = containerMapping.getContainerPolicy();
            if (mapping.isAbstractCompositeCollectionMapping() && (compositeMapping = (XMLCompositeCollectionMapping)mapping).getContainerAccessor() != null && (oldContainer = mapping.getAttributeValueFromObject(this.entity)) != null) {
                AbstractSession session = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
                Object iterator = containerPolicy.iteratorFor(oldContainer);
                while (containerPolicy.hasNext(iterator)) {
                    Object oldValue = containerPolicy.next(iterator, session);
                    compositeMapping.getContainerAccessor().setAttributeValueInObject(oldValue, null);
                }
            }
            Object container = containerPolicy.containerInstance();
            mapping.getAttributeAccessor().setAttributeValueInObject(this.entity, container);
        } else {
            XMLCompositeObjectMapping compositeMapping;
            Object oldValue = mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
            if (mapping.isAbstractCompositeObjectMapping() && (compositeMapping = (XMLCompositeObjectMapping)mapping).getContainerAccessor() != null && oldValue != null) {
                compositeMapping.getContainerAccessor().setAttributeValueInObject(oldValue, null);
            }
            mapping.getAttributeAccessor().setAttributeValueInObject(this.entity, null);
        }
    }

    public Object getOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    public void setOpenContentProperty(Property property, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean isSetOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    public void unsetOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    public void setManyProperty(Property property, Object value) {
        DatabaseMapping mapping = this.getJAXBMappingForProperty((SDOProperty)property);
        ContainerMapping containerMapping = (ContainerMapping)((Object)mapping);
        ContainerPolicy containerPolicy = containerMapping.getContainerPolicy();
        AbstractSession session = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
        List<Object> collection = (List<Object>)value;
        if (!property.getType().isDataType()) {
            collection = this.getJAXBHelperContext().unwrap((Collection<DataObject>)collection);
        }
        Iterator collectionIterator = collection.iterator();
        Object container = containerMapping.getContainerPolicy().containerInstance();
        while (collectionIterator.hasNext()) {
            Object collectionValue = collectionIterator.next();
            containerPolicy.addInto(collectionValue, container, session);
        }
        mapping.setAttributeValueInObject(this.entity, container);
    }

    public ValueStore copy() {
        throw new UnsupportedOperationException();
    }

    DatabaseMapping getJAXBMappingForProperty(SDOProperty sdoProperty) {
        XMLField field;
        DatabaseMapping sdoMapping = sdoProperty.getXmlMapping();
        if (sdoMapping instanceof XMLObjectReferenceMapping) {
            XMLObjectReferenceMapping referenceMapping = (XMLObjectReferenceMapping)sdoMapping;
            field = (XMLField)referenceMapping.getFields().get(0);
        } else {
            field = (XMLField)sdoMapping.getField();
        }
        TreeObjectBuilder treeObjectBuilder = (TreeObjectBuilder)this.descriptor.getObjectBuilder();
        XPathNode xPathNode = treeObjectBuilder.getRootXPathNode();
        XPathFragment xPathFragment = field.getXPathFragment();
        while (xPathNode != null && xPathFragment != null) {
            if (xPathFragment.isAttribute()) {
                if (sdoProperty.isMany() && !sdoProperty.isContainment() && !sdoProperty.getType().isDataType()) {
                    xPathFragment = null;
                    break;
                }
                Map attributeChildrenMap = xPathNode.getAttributeChildrenMap();
                xPathNode = null == attributeChildrenMap ? null : (XPathNode)xPathNode.getAttributeChildrenMap().get(xPathFragment);
            } else {
                Map nonAttributeChildrenMap = xPathNode.getNonAttributeChildrenMap();
                xPathNode = null == nonAttributeChildrenMap ? null : (XPathNode)xPathNode.getNonAttributeChildrenMap().get(xPathFragment);
            }
            if ((xPathFragment = xPathFragment.getNextFragment()) == null || !xPathFragment.nameIsText() || !sdoProperty.isMany() || sdoProperty.isContainment()) continue;
            xPathFragment = null;
            break;
        }
        if (null == xPathFragment && xPathNode != null && xPathNode.getNodeValue().isMappingNodeValue()) {
            MappingNodeValue mappingNodeValue = (MappingNodeValue)xPathNode.getNodeValue();
            return mappingNodeValue.getMapping();
        }
        throw SDOException.sdoJaxbNoMappingForProperty(sdoProperty.getName(), field.getXPath());
    }
}

