/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.mappings.transformers.AttributeTransformerAdapter;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class QNameTransformer
extends AttributeTransformerAdapter {
    public static final Map<String, QName> SCHEMA_QNAMES = new HashMap<String, QName>(){
        {
            this.put("anySimpleType", XMLConstants.ANY_SIMPLE_TYPE_QNAME);
            this.put("base64Binary", XMLConstants.BASE_64_BINARY_QNAME);
            this.put("boolean", XMLConstants.BOOLEAN_QNAME);
            this.put("byte", XMLConstants.BYTE_QNAME);
            this.put("date", XMLConstants.DATE_QNAME);
            this.put("dateTime", XMLConstants.DATE_TIME_QNAME);
            this.put("decimal", XMLConstants.DECIMAL_QNAME);
            this.put("double", XMLConstants.DOUBLE_QNAME);
            this.put("float", XMLConstants.FLOAT_QNAME);
            this.put("hexBinary", XMLConstants.HEX_BINARY_QNAME);
            this.put("int", XMLConstants.INT_QNAME);
            this.put("integer", XMLConstants.INTEGER_QNAME);
            this.put("long", XMLConstants.LONG_QNAME);
            this.put("QName", XMLConstants.QNAME_QNAME);
            this.put("short", XMLConstants.SHORT_QNAME);
            this.put("string", XMLConstants.STRING_QNAME);
            this.put("time", XMLConstants.TIME_QNAME);
            this.put("unsignedByte", XMLConstants.UNSIGNED_BYTE_QNAME);
            this.put("unsignedInt", XMLConstants.UNSIGNED_INT_QNAME);
            this.put("unsignedShort", XMLConstants.UNSIGNED_SHORT_QNAME);
        }
    };

    public Object buildAttributeValue(Record record, Object object, Session session) {
        QName qname = null;
        String qNameAsString = record == null ? null : (String)record.get("type/text()");
        String nsURI = null;
        String prefix = null;
        String localPart = null;
        if (qNameAsString != null) {
            if (qNameAsString.charAt(0) == '{') {
                int endOfNamespaceURI = qNameAsString.indexOf(125);
                if (endOfNamespaceURI == -1) {
                    throw new IllegalArgumentException("cannot create QName from \"" + qNameAsString + "\", missing closing \"}\"");
                }
                nsURI = qNameAsString.substring(1, endOfNamespaceURI);
                localPart = qNameAsString.substring(endOfNamespaceURI + 1);
            } else {
                int colonIdx = qNameAsString.indexOf(58);
                if (colonIdx > 0) {
                    prefix = qNameAsString.substring(0, colonIdx);
                    localPart = qNameAsString.substring(colonIdx + 1);
                    DOMRecord domRecord = (DOMRecord)record;
                    nsURI = domRecord.resolveNamespacePrefix(prefix);
                    if (nsURI == null) {
                        nsURI = "";
                    }
                } else {
                    localPart = qNameAsString;
                }
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                qname = SCHEMA_QNAMES.get(localPart);
                if (qname == null) {
                    qname = new QName("http://www.w3.org/2001/XMLSchema", localPart, prefix == null ? "" : prefix);
                }
            } else {
                qname = new QName(nsURI == null ? "" : nsURI, localPart, prefix == null ? "" : prefix);
            }
        }
        return qname;
    }
}

