/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.platform.database.oracle;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.TimeZone;
import oracle.sql.TIMESTAMPTZ;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPHelper;

public class TIMESTAMPTZWrapper
implements Serializable {
    Timestamp ts;
    TimeZone tz;
    boolean isTimestampInGmt;

    public TIMESTAMPTZWrapper(TIMESTAMPTZ timestampTZ, Connection connection, boolean isTimestampInGmt) {
        try {
            this.ts = timestampTZ.timestampValue(connection);
            this.tz = TIMESTAMPHelper.extractTimeZone(timestampTZ.toBytes());
            this.isTimestampInGmt = isTimestampInGmt;
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception);
        }
    }

    public Timestamp getTimestamp() {
        return this.ts;
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public boolean isTimestampInGmt() {
        return this.isTimestampInGmt;
    }
}

