/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryHintMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedQueryMetadata
extends ORMetadata {
    private Enum m_lockMode;
    private List<QueryHintMetadata> m_hints = new ArrayList<QueryHintMetadata>();
    private String m_name;
    private String m_query;

    public NamedQueryMetadata() {
        super("<named-query>");
    }

    protected NamedQueryMetadata(String xmlElement) {
        super(xmlElement);
    }

    public NamedQueryMetadata(Annotation namedQuery, MetadataAccessibleObject accessibleObject) {
        super(namedQuery, accessibleObject);
        this.m_name = (String)MetadataHelper.invokeMethod("name", namedQuery);
        this.m_query = (String)MetadataHelper.invokeMethod("query", namedQuery);
        this.m_lockMode = (Enum)MetadataHelper.invokeMethod("lockMode", namedQuery);
        for (Annotation hint : (Annotation[])MetadataHelper.invokeMethod("hints", namedQuery)) {
            this.m_hints.add(new QueryHintMetadata(hint, accessibleObject));
        }
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NamedQueryMetadata) {
            NamedQueryMetadata query = (NamedQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, query.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_query, query.getQuery())) {
                return false;
            }
            return this.valuesMatch(this.m_hints, query.getHints());
        }
        return false;
    }

    public List<QueryHintMetadata> getHints() {
        return this.m_hints;
    }

    @Override
    public String getIdentifier() {
        return this.m_name;
    }

    public Enum getLockMode() {
        return this.m_lockMode;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void process(AbstractSession session, ClassLoader loader) {
        try {
            Map<String, Object> hints = this.processQueryHints(session);
            session.addJPAQuery(new JPAQuery(this.getName(), this.getQuery(), this.getLockMode(), hints));
        }
        catch (Exception exception) {
            throw ValidationException.errorProcessingNamedQuery(this.getClass(), this.getName(), exception);
        }
    }

    protected Map<String, Object> processQueryHints(AbstractSession session) {
        HashMap<String, Object> hints = new HashMap<String, Object>();
        for (QueryHintMetadata hint : this.m_hints) {
            QueryHintsHandler.verify(hint.getName(), hint.getValue(), this.m_name, session);
            Object value = hints.get(hint.getName());
            if (value != null) {
                Object[] values = null;
                if (value instanceof Object[]) {
                    ArrayList<Object> list = new ArrayList<Object>(Arrays.asList((Object[])value));
                    list.add(hint.getValue());
                    values = list.toArray();
                } else {
                    values = new Object[]{value, hint.getValue()};
                }
                hints.put(hint.getName(), values);
                continue;
            }
            hints.put(hint.getName(), hint.getValue());
        }
        return hints;
    }

    public void setHints(List<QueryHintMetadata> hints) {
        this.m_hints = hints;
    }

    public void setLockMode(Enum lockMode) {
        this.m_lockMode = lockMode;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }
}

