/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class DatacenterId
extends ResourceId
implements Comparable<DatacenterId> {
    private static final long serialVersionUID = 1L;
    public static final String DATACENTER_PREFIX = "zn";
    public static final String[] ALL_DATACENTER_PREFIXES = new String[]{"zn", "dc"};
    private int datacenterId;

    public DatacenterId(int datacenterId) {
        this.datacenterId = datacenterId;
    }

    private DatacenterId() {
    }

    DatacenterId(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.datacenterId = in.readInt();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.datacenterId);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.DATACENTER;
    }

    public int getDatacenterId() {
        return this.datacenterId;
    }

    public String toString() {
        return DATACENTER_PREFIX + this.datacenterId;
    }

    public static DatacenterId parse(String s) {
        return new DatacenterId(DatacenterId.parseForInt(ALL_DATACENTER_PREFIXES, s));
    }

    public Datacenter getComponent(Topology topology) {
        return topology.get(this);
    }

    protected Datacenter readComponent(Topology topology, DataInput in, short serialVersion) throws IOException {
        return Datacenter.readFastExternal(topology, this, in, serialVersion);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatacenterId other = (DatacenterId)obj;
        return this.datacenterId == other.datacenterId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.datacenterId;
        return result;
    }

    @Override
    public int compareTo(DatacenterId other) {
        return this.datacenterId - other.datacenterId;
    }

    @Override
    public DatacenterId clone() {
        return new DatacenterId(this.datacenterId);
    }
}

