/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.tests.validation.ExceptionTestSaveDescriptor;
import org.eclipse.persistence.testing.tests.validation.PersonWithValueHolder;

public class StructureNameNotSetInMappingTest
extends ExceptionTestSaveDescriptor {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public StructureNameNotSetInMappingTest() {
        this.setDescription("This tests Structure Name Not Set In Mapping (TL-ERROR 156)");
    }

    @Override
    protected void setup() {
        this.expectedException = DescriptorException.structureNameNotSetInMapping((DatabaseMapping)new ArrayMapping());
        super.setup();
    }

    public void test() {
        try {
            ((DatabaseSession)this.getSession()).addDescriptor(this.descriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public ClassDescriptor descriptor() {
        ObjectRelationalDataTypeDescriptor descriptor = new ObjectRelationalDataTypeDescriptor();
        descriptor.setJavaClass(PersonWithValueHolder.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("p_id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        ArrayMapping projectsMapping = new ArrayMapping();
        projectsMapping.setAttributeName("projects");
        projectsMapping.setFieldName("EMPLOYEE.F_NAME");
        descriptor.addMapping((DatabaseMapping)projectsMapping);
        return descriptor;
    }
}

