/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class PromoteIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final ExprType theTargetType;

    public PromoteIter(Expr e, int resultReg, PlanIter inputIter, ExprType type) {
        super(e, resultReg);
        this.theInputIter = inputIter;
        this.theTargetType = type;
    }

    PromoteIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInputIter = PromoteIter.deserializeIter(in, serialVersion);
        this.theTargetType = PromoteIter.deserializeExprType(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        PromoteIter.serializeIter(this.theInputIter, out, serialVersion);
        PromoteIter.serializeExprType(this.theTargetType, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.PROMOTE;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theInputIter.getTupleRegs();
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        this.theInputIter.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        ExprType.Quantifier quant = this.theTargetType.getQuantifier();
        boolean more = this.theInputIter.next(rcb);
        if (!more) {
            if (quant == ExprType.Quantifier.ONE || quant == ExprType.Quantifier.PLUS) {
                throw new QueryException("Empty result set cannot be promoted to type " + this.theTargetType, this.getLocation());
            }
            state.done();
            return false;
        }
        if (quant == ExprType.Quantifier.ONE || quant == ExprType.Quantifier.QSTN) {
            if (this.theInputIter.next(rcb)) {
                throw new QueryException("Result set with more than one item cannot be promoted  to type " + this.theTargetType, this.getLocation());
            }
            this.promoteValue(rcb);
            state.done();
            return true;
        }
        this.promoteValue(rcb);
        return true;
    }

    private void promoteValue(RuntimeControlBlock rcb) {
        FieldValueImpl retValue;
        int inputReg = this.theInputIter.getResultReg();
        FieldValueImpl inValue = rcb.getRegVal(inputReg);
        if (inValue.isNull()) {
            retValue = NullValueImpl.getInstance();
        } else {
            retValue = TypeManager.promote(inValue, this.theTargetType);
            if (retValue == null) {
                throw new QueryException("Cannot promote item of type :\n" + inValue.getDefinition() + "\nto type :\n" + this.theTargetType, this.getLocation());
            }
        }
        if (rcb.getTraceLevel() >= 3) {
            rcb.trace("Promoted value\n" + inValue + "\nto value\n" + retValue);
        }
        rcb.setRegVal(this.theResultReg, retValue);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append(this.theTargetType);
        sb.append(",\n");
        this.theInputIter.display(sb, formatter);
    }
}

