/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import com.sleepycat.util.PackedInteger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import oracle.kv.impl.async.BytesInput;
import oracle.kv.impl.async.dialog.ChannelInput;
import oracle.kv.impl.async.dialog.netty.NettyBytesInput;

class NettyChannelInput
implements ChannelInput {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private final byte[] packedLongBytes = new byte[9];
    private ByteBuf buffer = null;

    NettyChannelInput() {
    }

    @Override
    public void mark() {
        this.buffer.markReaderIndex();
    }

    @Override
    public void reset() {
        this.buffer.resetReaderIndex();
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public byte readByte() {
        return this.buffer.readByte();
    }

    @Override
    public BytesInput readBytes(int len) {
        ByteBuf buf = this.buffer.readRetainedSlice(len);
        return new NettyBytesInput(buf);
    }

    @Override
    public boolean canReadPackedLong() {
        if (this.buffer.readableBytes() == 0) {
            return false;
        }
        return this.buffer.readableBytes() >= this.peekPackedLongLength();
    }

    @Override
    public long readPackedLong() {
        int len = this.peekPackedLongLength();
        this.buffer.readBytes(this.packedLongBytes, 0, len);
        return PackedInteger.readLong(this.packedLongBytes, 0);
    }

    private int peekPackedLongLength() {
        this.packedLongBytes[0] = this.buffer.getByte(this.buffer.readerIndex());
        return PackedInteger.getReadLongLength(this.packedLongBytes, 0);
    }

    @Override
    public String readUTF8(int length) {
        if (this.buffer.readableBytes() < length) {
            return null;
        }
        byte[] bytes = new byte[length];
        this.buffer.readBytes(bytes, 0, length);
        return utf8.decode(ByteBuffer.wrap(bytes)).toString();
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelInput:");
        if (this.buffer == null) {
            return builder.toString();
        }
        int rlen = Math.min(32, this.buffer.readableBytes());
        int wlen = Math.min(32, this.buffer.writableBytes());
        builder.append("R:");
        builder.append(ByteBufUtil.hexDump((ByteBuf)this.buffer, (int)this.buffer.readerIndex(), (int)rlen));
        builder.append("W:");
        builder.append(ByteBufUtil.hexDump((ByteBuf)this.buffer, (int)this.buffer.writerIndex(), (int)wlen));
        return builder.toString();
    }

    void feed(ByteBuf buf) {
        this.buffer = buf;
    }
}

