/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import oracle.kv.impl.async.AbstractEndpointGroup;
import oracle.kv.impl.async.AbstractResponderEndpoint;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointGroup;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.SocketPrepared;

public abstract class AbstractListener {
    private final AbstractEndpointGroup endpointGroup;
    protected final ListenerConfig listenerConfig;
    protected final EndpointConfig endpointConfig;
    protected final Set<AbstractResponderEndpoint> acceptedEndpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Integer, DialogHandlerFactory> dialogHandlerFactories;
    private final AtomicReference<SocketPrepared> socketPreparedRef = new AtomicReference<Object>(null);
    private volatile boolean isShutdown = false;

    protected AbstractListener(AbstractEndpointGroup endpointGroup, ListenerConfig listenerConfig, Map<Integer, DialogHandlerFactory> dialogHandlerFactories) {
        this.endpointGroup = endpointGroup;
        this.listenerConfig = listenerConfig;
        this.dialogHandlerFactories = dialogHandlerFactories;
        this.endpointConfig = listenerConfig.getEndpointConfig();
    }

    ListenerConfig getListenerConfig() {
        return this.listenerConfig;
    }

    AsyncHandle newListenHandle(int dialogType, DialogHandlerFactory handlerFactory) throws IOException {
        assert (Thread.holdsLock(this.endpointGroup));
        if (this.dialogHandlerFactories.containsKey(dialogType)) {
            throw new IllegalStateException(String.format("Already start listening for dialogType=%s with %s", dialogType, this.dialogHandlerFactories.get(dialogType)));
        }
        this.createChannel();
        this.dialogHandlerFactories.put(dialogType, handlerFactory);
        return new AsyncHandle(dialogType);
    }

    SyncHandle newListenHandle(SocketPrepared socketPrepared) throws IOException {
        assert (Thread.holdsLock(this.endpointGroup));
        SocketPrepared existing = this.socketPreparedRef.get();
        if (existing != null) {
            throw new IllegalStateException(String.format("Already start listening with %s", existing));
        }
        this.createChannel();
        this.socketPreparedRef.set(socketPrepared);
        return new SyncHandle(socketPrepared);
    }

    public void shutdown() {
        assert (Thread.holdsLock(this.endpointGroup));
        this.endpointGroup.removeListener(this);
        this.closeChannel();
        this.isShutdown = true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public Map<Integer, DialogHandlerFactory> getDialogHandlerFactories() {
        return this.dialogHandlerFactories;
    }

    public SocketPrepared getSocketPrepared() {
        return this.socketPreparedRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelError(Throwable t, boolean channelClosed) {
        AbstractEndpointGroup abstractEndpointGroup = this.endpointGroup;
        synchronized (abstractEndpointGroup) {
            this.shutdown();
            for (DialogHandlerFactory factory : this.dialogHandlerFactories.values()) {
                factory.onChannelError(this.listenerConfig, t, channelClosed);
            }
            SocketPrepared socketPrepared = this.socketPreparedRef.get();
            if (socketPrepared != null) {
                socketPrepared.onChannelError(this.listenerConfig, t, channelClosed);
            }
        }
    }

    public void removeResponderEndpoint(AbstractResponderEndpoint endpoint) {
        this.acceptedEndpoints.remove(endpoint);
    }

    protected abstract void createChannel() throws IOException;

    protected abstract void closeChannel();

    protected abstract NetworkAddress getLocalAddress();

    class SyncHandle
    extends Handle {
        private final SocketPrepared socketPrepared;

        SyncHandle(SocketPrepared socketPrepared) {
            this.socketPrepared = socketPrepared;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown(boolean force) {
            AbstractEndpointGroup abstractEndpointGroup = AbstractListener.this.endpointGroup;
            synchronized (abstractEndpointGroup) {
                if (AbstractListener.this.socketPreparedRef.compareAndSet(this.socketPrepared, null)) {
                    // empty if block
                }
                this.shutdownIfInactive(force);
            }
        }

        public String toString() {
            return String.format("SyncHandle[ listener=%s socketPrepared=%s ]", AbstractListener.this, this.socketPrepared);
        }
    }

    class AsyncHandle
    extends Handle {
        private final int dialogType;

        AsyncHandle(int dialogType) {
            this.dialogType = dialogType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown(boolean force) {
            AbstractEndpointGroup abstractEndpointGroup = AbstractListener.this.endpointGroup;
            synchronized (abstractEndpointGroup) {
                AbstractListener.this.dialogHandlerFactories.remove(this.dialogType);
                this.shutdownIfInactive(force);
            }
        }

        public String toString() {
            return String.format("AsyncHandle[ listener=%s dialogType=%d dialogHandlerFactory=%s ]", AbstractListener.this, this.dialogType, AbstractListener.this.dialogHandlerFactories.get(this.dialogType));
        }
    }

    abstract class Handle
    implements EndpointGroup.ListenHandle {
        private final NetworkAddress localAddress;

        Handle() {
            this.localAddress = AbstractListener.this.getLocalAddress();
        }

        @Override
        public ListenerConfig getListenerConfig() {
            return AbstractListener.this.listenerConfig;
        }

        @Override
        public NetworkAddress getLocalAddress() {
            return this.localAddress;
        }

        protected void shutdownIfInactive(boolean force) {
            assert (Thread.holdsLock(AbstractListener.this.endpointGroup));
            if (!AbstractListener.this.dialogHandlerFactories.isEmpty() || AbstractListener.this.socketPreparedRef.get() != null) {
                return;
            }
            AbstractListener.this.shutdown();
            while (!AbstractListener.this.acceptedEndpoints.isEmpty()) {
                Iterator<AbstractResponderEndpoint> iter = AbstractListener.this.acceptedEndpoints.iterator();
                while (iter.hasNext()) {
                    AbstractResponderEndpoint endpoint = iter.next();
                    iter.remove();
                    endpoint.shutdown("Stop listening", force);
                }
            }
        }
    }
}

