/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class ReadObjectCallTest
extends AutoVerifyTestCase {
    protected Object objectFromDatabase;
    protected Call call;
    protected Class<?> referenceClass;

    public ReadObjectCallTest() {
        this.setDescription("The test reads the intended object from the database through the call and checks if it was read properly");
    }

    public ReadObjectCallTest(Class<?> referenceClass, Call aCall) {
        this.setReferenceClass(referenceClass);
        this.setCall(aCall);
        this.setName("ReadObjectCallTest(" + referenceClass + ")");
        this.setDescription("The test reads the intended object through the call, '" + referenceClass + "', from the database and checks if it was read properly");
    }

    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    public void setReferenceClass(Class<?> referenceClass) {
        this.referenceClass = referenceClass;
    }

    public Call getCall() {
        return this.call;
    }

    public void setCall(Call aCall) {
        this.call = aCall;
    }

    @Override
    protected void setup() {
        if (this.getSession().getLogin().getTableQualifier() != "") {
            throw new TestWarningException("this test can't work with table qualifier set");
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    @Override
    protected void test() {
        this.objectFromDatabase = this.getSession().readObject(this.getReferenceClass(), this.getCall());
    }

    @Override
    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        if (!this.compareObjects(this.getSession().readObject(this.objectFromDatabase), this.objectFromDatabase)) {
            throw new TestErrorException("The object read from the database, '" + this.objectFromDatabase + "' does not match the originial.");
        }
    }
}

