/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.workbenchintegration.WorkbenchIntegrationSystemHelper;

public class EmployeeWorkbenchIntegrationSystem
extends EmployeeSystem {
    public static String PROJECT_FILE = "MWIntegrationTestEmployeeProject";
    public static int QUERY_MANAGER_TIMEOUT = 250;
    private Project initialProject;

    public EmployeeWorkbenchIntegrationSystem() {
        this.buildInitialProject();
        this.buildProject();
    }

    protected void buildProject() {
        this.project = WorkbenchIntegrationSystemHelper.buildProjectXML(this.getInitialProject(), PROJECT_FILE);
    }

    public Project getInitialProject() {
        return this.initialProject;
    }

    protected void buildInitialProject() {
        this.initialProject = new EmployeeProject();
        Map descriptors = this.initialProject.getDescriptors();
        ClassDescriptor employeeDescriptor = (ClassDescriptor)descriptors.get(Employee.class);
        DescriptorQueryManager queryManager = employeeDescriptor.getQueryManager();
        queryManager.addQuery("PersistenceTestGetEqual", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetEqualQuery());
        queryManager.addQuery("PersistenceTestAnyOfEqual", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestAnyOfEqualQuery());
        queryManager.addQuery("PersistenceTestGetAllowingNullEqual", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetAllowingNullEqualQuery());
        queryManager.addQuery("PersistenceTestAnyOfAllowingNoneEqual", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestAnyOfAllowingNoneEqualQuery());
        queryManager.addQuery("PersistenceTestGetGreaterThan", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetGreaterThanQuery());
        queryManager.addQuery("PersistenceTestGetGreaterThanEqual", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetGreaterThanEqualQuery());
        queryManager.addQuery("PersistenceTestGetIsNull", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetIsNullQuery());
        queryManager.addQuery("PersistenceTestGetEqualIgnoringCase", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetEqualIgnoringCaseQuery());
        queryManager.addQuery("PersistenceTestGetLessThan", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetLessThanQuery());
        queryManager.addQuery("PersistenceTestGetLessThanEqual", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetLessThanEqualQuery());
        queryManager.addQuery("PersistenceTestGetLike", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetLikeQuery());
        queryManager.addQuery("PersistenceTestGetNot", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetNotQuery());
        queryManager.addQuery("PersistenceTestGetNotEqual", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetNotEqualQuery());
        queryManager.addQuery("PersistenceTestGetNotLike", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetNotLikeQuery());
        queryManager.addQuery("PersistenceTestGetNotNull", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGetNotNullQuery());
        queryManager.addQuery("PersistenceTestEmptyStringAndNull", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestEmptyStringAndNull());
        queryManager.addQuery("PersistenceTestGreaterThanEqualDate", EmployeeWorkbenchIntegrationSystem.buildPersistenceTestGreaterThanEqualDateQuery());
        queryManager.addQuery("AddAttributeReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddAttributeReportQueryTest());
        queryManager.addQuery("AddAverageReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddAverageReportQueryTest());
        queryManager.addQuery("AddCountReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddCountReportQueryTest());
        queryManager.addQuery("AddFunctionItemReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddFunctionItemReportQueryTest());
        queryManager.addQuery("AddGroupingReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddGroupingReportQueryTest());
        queryManager.addQuery("AddItemReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddItemReportQueryTest());
        queryManager.addQuery("AddMaximumReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddMaximumReportQueryTest());
        queryManager.addQuery("AddMinimumReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddMinimumReportQueryTest());
        queryManager.addQuery("AddStandardDeviationReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddStandardDeviationReportQueryTest());
        queryManager.addQuery("AddSumReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddSumReportQueryTest());
        queryManager.addQuery("AddVarianceReportQuery", EmployeeWorkbenchIntegrationSystem.buildAddVarianceReportQueryTest());
        queryManager.addQuery("AddJoinedObjectLevelReadQuery", EmployeeWorkbenchIntegrationSystem.buildAddJoinedReportQueryTest());
        queryManager.addQuery("AddOrderingReadAllQuery", EmployeeWorkbenchIntegrationSystem.buildAddOrderingReportQueryTest());
        queryManager.addQuery("AddBatchReadReadAllQuery", EmployeeWorkbenchIntegrationSystem.buildAddBatchReadReportQueryTest());
        this.buildMemoryQueryReturnConfirmedQuery(queryManager);
        this.buildMemoryQueryThrowExceptionQuery(queryManager);
        this.buildMemoryQueryReturnNotConfirmedQuery(queryManager);
        this.buildMemoryQueryTriggerIndirectionQuery(queryManager);
        this.buildCacheQueryResultsQuery(queryManager);
        this.buildRefreshIdentityMapResultsQuery(queryManager);
        this.buildMaxRowsQuery(queryManager);
        this.buildFirstResultQuery(queryManager);
        this.buildQueryTimeOutQuery(queryManager);
        this.buildUseDistinctQuery(queryManager);
        this.buildDoNotUseDistinctQuery(queryManager);
        this.buildShouldPrepareQuery(queryManager);
        this.buildReadOnlyQuery(queryManager);
        ClassDescriptor projectDescriptor = (ClassDescriptor)descriptors.get(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        if (!TestExecutor.getDefaultExecutor().getSession().getPlatform().isPostgreSQL()) {
            projectDescriptor.getQueryManager().setQueryTimeout(QUERY_MANAGER_TIMEOUT);
        }
        projectDescriptor.setCacheSynchronizationType(3);
        projectDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new NoExpiryCacheInvalidationPolicy());
        this.buildJoinSubclassesQuery(projectDescriptor.getQueryManager());
        employeeDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(10000000L));
        ((ClassDescriptor)descriptors.get(Address.class)).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(10000000L));
        ((ClassDescriptor)descriptors.get(PhoneNumber.class)).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(10000000L));
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(11, 2);
        ((ClassDescriptor)descriptors.get(LargeProject.class)).setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)));
        ((ClassDescriptor)descriptors.get(SmallProject.class)).setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)));
    }

    public static DatabaseQuery buildPersistenceTestGetEqualQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").get("city").equal((Object)"Toronto");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetEqualIgnoringCaseQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").get("city").equalsIgnoreCase("Toronto");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestAnyOfEqualQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.anyOf("phoneNumbers").get("areaCode").equal((Object)"613");
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetAllowingNullEqualQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.getAllowingNull("address").get("city").equal((Object)"Toronto");
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestAnyOfAllowingNoneEqualQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.anyOfAllowingNone("phoneNumbers").get("areaCode").equal((Object)"613");
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetGreaterThanQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("salary").greaterThan(0);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetGreaterThanEqualQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("salary").greaterThanEqual(0);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetIsNullQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").isNull();
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetLessThanQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("salary").lessThan(15);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetLessThanEqualQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("salary").lessThanEqual(15);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetLikeQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").get("city").like("Toronto");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetNotQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").get("city").equal((Object)"Toronto").not();
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetNotEqualQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").get("city").notEqual((Object)"Toronto");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetNotLikeQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").get("city").notLike("Toronto");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEmptyStringAndNull() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("firstName").lessThan(null).or(builder.get("firstName").equal((Object)""));
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGetNotNullQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("firstName").notNull();
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestGreaterThanEqualDateQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Date date = Date.valueOf("2001-07-01");
        Expression expression = builder.get("period").get("startDate").greaterThanEqual((Object)date);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildAddAttributeReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addAttribute("gender");
        return reportQuery;
    }

    public static DatabaseQuery buildAddAverageReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addAverage("salary");
        return reportQuery;
    }

    public static DatabaseQuery buildAddCountReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addCount("id");
        return reportQuery;
    }

    public static DatabaseQuery buildAddFunctionItemReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addFunctionItem("salary", reportQuery.getExpressionBuilder().get("salary"), "AVG");
        return reportQuery;
    }

    public static DatabaseQuery buildAddGroupingReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addAttribute("gender");
        reportQuery.addGrouping("gender");
        return reportQuery;
    }

    public static DatabaseQuery buildAddItemReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addItem("name", reportQuery.getExpressionBuilder().get("firstName"));
        return reportQuery;
    }

    public static DatabaseQuery buildAddMaximumReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addMaximum("salary");
        return reportQuery;
    }

    public static DatabaseQuery buildAddMinimumReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addMinimum("managerSalary", reportQuery.getExpressionBuilder().get("manager").get("salary"));
        return reportQuery;
    }

    public static DatabaseQuery buildAddStandardDeviationReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addStandardDeviation("salary");
        return reportQuery;
    }

    public static DatabaseQuery buildAddSumReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addSum("salary");
        return reportQuery;
    }

    public static DatabaseQuery buildAddVarianceReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addVariance("id");
        return reportQuery;
    }

    public static DatabaseQuery buildAddJoinedReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addAttribute("gender");
        reportQuery.addJoinedAttribute("address");
        return reportQuery;
    }

    public static DatabaseQuery buildAddOrderingReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addAttribute("gender");
        reportQuery.addDescendingOrdering("firstName");
        return reportQuery;
    }

    public static DatabaseQuery buildAddBatchReadReportQueryTest() {
        ReportQuery reportQuery = new ReportQuery(new ExpressionBuilder());
        reportQuery.setReferenceClass(Employee.class);
        reportQuery.addAttribute("gender");
        reportQuery.addBatchReadAttribute("phoneNumbers");
        return reportQuery;
    }

    public void buildMemoryQueryReturnConfirmedQuery(DescriptorQueryManager queryManager) {
        ReadAllQuery namedQuery = new ReadAllQuery(Employee.class);
        namedQuery.setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(2));
        queryManager.addQuery("memoryQueryReturnConfirmedQuery", (DatabaseQuery)namedQuery);
    }

    public void buildMemoryQueryThrowExceptionQuery(DescriptorQueryManager queryManager) {
        ReadObjectQuery namedQuery = new ReadObjectQuery(Employee.class);
        namedQuery.setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(0));
        queryManager.addQuery("memoryQueryThrowExceptionQuery", (DatabaseQuery)namedQuery);
    }

    public void buildMemoryQueryReturnNotConfirmedQuery(DescriptorQueryManager queryManager) {
        ReadAllQuery namedQuery = new ReadAllQuery(Employee.class);
        namedQuery.setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(3));
        queryManager.addQuery("memoryQueryReturnNotConfirmedQuery", (DatabaseQuery)namedQuery);
    }

    public void buildMemoryQueryTriggerIndirectionQuery(DescriptorQueryManager queryManager) {
        ReadAllQuery namedQuery = new ReadAllQuery(Employee.class);
        namedQuery.setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(1));
        queryManager.addQuery("memoryQueryTriggerIndirectionQuery", (DatabaseQuery)namedQuery);
    }

    public void buildCacheQueryResultsQuery(DescriptorQueryManager queryManager) {
        ReadObjectQuery namedQuery = new ReadObjectQuery(Employee.class);
        namedQuery.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
        queryManager.addQuery("cacheQueryResultsQuery", (DatabaseQuery)namedQuery);
    }

    public void buildRefreshIdentityMapResultsQuery(DescriptorQueryManager queryManager) {
        ReadObjectQuery namedQuery = new ReadObjectQuery(Employee.class);
        namedQuery.setShouldRefreshIdentityMapResult(true);
        queryManager.addQuery("refreshIdentityMapResultsQuery", (DatabaseQuery)namedQuery);
    }

    public void buildReadOnlyQuery(DescriptorQueryManager queryManager) {
        ReadObjectQuery namedQuery = new ReadObjectQuery(Employee.class);
        namedQuery.setIsReadOnly(true);
        queryManager.addQuery("readOnlyQuery", (DatabaseQuery)namedQuery);
    }

    public void buildJoinSubclassesQuery(DescriptorQueryManager queryManager) {
        ReadAllQuery namedQuery = new ReadAllQuery(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        namedQuery.useCursoredStream();
        namedQuery.setShouldOuterJoinSubclasses(true);
        queryManager.addQuery("joinSubclassesQuery", (DatabaseQuery)namedQuery);
    }

    public void buildMaxRowsQuery(DescriptorQueryManager queryManager) {
        ReadAllQuery namedQuery = new ReadAllQuery(Employee.class);
        namedQuery.setMaxRows(4);
        queryManager.addQuery("maxRowsQuery", (DatabaseQuery)namedQuery);
    }

    public void buildFirstResultQuery(DescriptorQueryManager queryManager) {
        ReadAllQuery namedQuery = new ReadAllQuery(Employee.class);
        namedQuery.setFirstResult(2);
        queryManager.addQuery("firstResultQuery", (DatabaseQuery)namedQuery);
    }

    public void buildQueryTimeOutQuery(DescriptorQueryManager queryManager) {
        DataReadQuery namedQuery = new DataReadQuery();
        namedQuery.setSQLString("SELECT SUM(e.EMP_ID) from EMPLOYEE e , EMPLOYEE b, EMPLOYEE c, EMPLOYEE d, EMPLOYEE f, EMPLOYEE g, EMPLOYEE h");
        namedQuery.setQueryTimeout(1);
        queryManager.addQuery("queryTimeOutQuery", (DatabaseQuery)namedQuery);
    }

    public void buildUseDistinctQuery(DescriptorQueryManager queryManager) {
        ReadAllQuery namedQuery = new ReadAllQuery(Employee.class);
        namedQuery.setDistinctState((short)1);
        queryManager.addQuery("useDistinctQuery", (DatabaseQuery)namedQuery);
    }

    public void buildDoNotUseDistinctQuery(DescriptorQueryManager queryManager) {
        ReadAllQuery namedQuery = new ReadAllQuery(Employee.class);
        namedQuery.setDistinctState((short)2);
        queryManager.addQuery("doNotUseDistinctQuery", (DatabaseQuery)namedQuery);
    }

    public void buildShouldPrepareQuery(DescriptorQueryManager queryManager) {
        ReadObjectQuery namedQuery = new ReadObjectQuery(Employee.class);
        queryManager.addQuery("shouldPrepareQuery", (DatabaseQuery)namedQuery);
    }
}

