/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.models.conversion.ConversionDataObject;
import org.eclipse.persistence.testing.models.conversion.ConversionManagerSystem;
import org.eclipse.persistence.testing.tests.workbenchintegration.WorkbenchIntegrationSystemHelper;

public class CMWorkbenchIntegrationSystem
extends ConversionManagerSystem {
    public static String PROJECT_FILE = "MWIntegrationTestCMProject";
    public ClassDescriptor cmDescriptor;

    public CMWorkbenchIntegrationSystem() {
        ClassDescriptor descriptor = (ClassDescriptor)this.project.getDescriptors().get(ConversionDataObject.class);
        this.addNamedQueries(descriptor.getQueryManager());
        this.buildProject();
    }

    protected void buildProject() {
        this.project = WorkbenchIntegrationSystemHelper.buildProjectXML(this.project, PROJECT_FILE);
    }

    public void addNamedQueries(DescriptorQueryManager queryManager) {
        queryManager.addQuery("PersistenceTestEqualCalendar", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualCalendarQuery());
        queryManager.addQuery("PersistenceTestEqualJavaDate", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualJavaDateQuery());
        queryManager.addQuery("PersistenceTestEqualSqlDate", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualSqlDateQuery());
        queryManager.addQuery("PersistenceTestEqualTime", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualTimeQuery());
        queryManager.addQuery("PersistenceTestEqualTimestamp", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualTimestampQuery());
        queryManager.addQuery("PersistenceTestEqualBigDecimal", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualBigDecimalQuery());
        queryManager.addQuery("PersistenceTestEqualBigInteger", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualBigIntegerQuery());
        queryManager.addQuery("PersistenceTestEqualPChar", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualPCharQuery());
        queryManager.addQuery("PersistenceTestEqualCharacter", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualCharacterQuery());
        queryManager.addQuery("PersistenceTestEqualPCharArray", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualPCharArrayQuery());
        queryManager.addQuery("PersistenceTestEqualPByte", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualPByteQuery());
        queryManager.addQuery("PersistenceTestEqualPByteArray", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualPByteArrayQuery());
        queryManager.addQuery("PersistenceTestEqualByte", CMWorkbenchIntegrationSystem.buildPersistenceTestEqualByteQuery());
    }

    public static DatabaseQuery buildPersistenceTestEqualCalendarQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        GregorianCalendar month = new GregorianCalendar();
        month.clear();
        month.set(2001, 6, 1, 11, 24, 36);
        Expression expression = builder.get("aCalendar").equal((Object)month);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualJavaDateQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Date date = new Date(994007776134L);
        Expression expression = builder.get("aJavaDate").equal((Object)date);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualSqlDateQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        java.sql.Date date = new java.sql.Date(994007776000L);
        Expression expression = builder.get("anSQLDate").equal((Object)date);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualTimeQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Time date = new Time(994007776134L);
        Expression expression = builder.get("aTime").equal((Object)date);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualTimestampQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Timestamp date = new Timestamp(994007776134L);
        Expression expression = builder.get("aTimestamp").equal((Object)date);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualBigDecimalQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        BigDecimal num = new BigDecimal(8.0);
        Expression expression = builder.get("aBigDecimal").equal((Object)num);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualBigIntegerQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        BigInteger num = new BigInteger("9");
        Expression expression = builder.get("aBigInteger").equal((Object)num);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualPCharQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Expression expression = builder.get("aPChar").equal('a');
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualCharacterQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Expression expression = builder.get("aCharacter").equal((Object)Character.valueOf('b'));
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualPCharArrayQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Expression expression = builder.get("aPCharArray").equal((Object)new char[]{'d', 'e', 'f'});
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualPByteQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Expression expression = builder.get("aPByte").equal(7);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualPByteArrayQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Expression expression = builder.get("aPByteArray").equal((Object)new byte[]{7, 8, 9});
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }

    public static DatabaseQuery buildPersistenceTestEqualByteQuery() {
        ExpressionBuilder builder = new ExpressionBuilder(ConversionDataObject.class);
        Expression expression = builder.get("aByte").equal((Object)3);
        ReadObjectQuery query = new ReadObjectQuery(ConversionDataObject.class);
        query.setSelectionCriteria(expression);
        return query;
    }
}

