/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ReadAllBatchTest
extends ReadAllTest {
    public Exception storedException;
    public int expectedExceptionCode;

    public ReadAllBatchTest(Class<?> aClass, int numberOfObjects) {
        super(aClass, numberOfObjects);
        this.setDescription("Test that the correct exception is thrown when a batch query across a variable 1:1 mapping is attempted. Maybe this will be supported someday.");
        this.storedException = null;
        this.expectedExceptionCode = 6006;
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.storedException = null;
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.storedException = null;
    }

    public void test() {
        try {
            super.test();
        }
        catch (Exception e) {
            this.storedException = e;
        }
    }

    public void verify() {
        if (this.storedException == null) {
            throw new TestErrorException("NO EXCEPTION THROWN!!!  EXPECTING QueryException");
        }
        if (EclipseLinkException.class.isInstance(this.storedException) && ((EclipseLinkException)((Object)this.storedException)).getErrorCode() == this.expectedExceptionCode) {
            return;
        }
        throw new TestErrorException("WRONG EXCEPTION THROWN!!!  EXPECTING QueryException");
    }
}

